/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.util.IOUtils;

public class TstTableWriter
extends StreamStarTableWriter {
    private static final int MAX_CHARS = 10240;
    private static final ColumnInfo ID_INFO = new ColumnInfo("ID", String.class, "Identifier");
    private static final ColumnInfo RA_INFO = new ColumnInfo("RA", Number.class, "Right Ascension J2000");
    private static final ColumnInfo DEC_INFO = new ColumnInfo("DEC", Number.class, "Declination J2000");
    private static final ColumnInfo X_INFO = new ColumnInfo("X", Number.class, "X pixel index");
    private static final ColumnInfo Y_INFO = new ColumnInfo("Y", Number.class, "Y pixel index");
    private static final ValueInfo LABEL_INFO = new DefaultValueInfo("TstTableWriter.Label", String.class, "Identifier private to this class");

    @Override
    public String getFormatName() {
        return "TST";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.endsWith(".tst") || location.endsWith(".TST") || location.endsWith(".TAB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable st, OutputStream out) throws IOException {
        st = TstTableWriter.prepareTable(st);
        String tname = st.getName();
        URL turl = st.getURL();
        if (tname != null && tname.trim().length() > 0) {
            TstTableWriter.printLine(out, tname);
        } else if (turl != null) {
            TstTableWriter.printLine(out, turl.toString().replaceFirst("^.*[:/]*", ""));
        } else {
            TstTableWriter.printLine(out, "# Tab Separated Table");
        }
        TstTableWriter.printLine(out, "");
        if (!st.getParameters().isEmpty()) {
            TstTableWriter.printLine(out, "# Table parameters");
            for (DescribedValue dval : st.getParameters()) {
                String name = dval.getInfo().getName();
                Object value = dval.getValue();
                if (name == null || name.trim().length() <= 0 || value == null) continue;
                name = name.trim().replaceAll(":", "_").replaceAll("\\s+", " ");
                String sval = dval.getValueAsString(320).trim().replaceAll("\\s+", " ");
                TstTableWriter.printLine(out, name + ": " + sval);
            }
            TstTableWriter.printLine(out, "");
        }
        int ncol = st.getColumnCount();
        ColumnInfo[] colInfos = new ColumnInfo[ncol];
        String[] colNames = new String[ncol];
        int raIndex = -1;
        int decIndex = -1;
        int idIndex = -1;
        int xIndex = -1;
        int yIndex = -1;
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info;
            colInfos[icol] = info = st.getColumnInfo(icol);
            colNames[icol] = info.getName().trim().replaceAll("\\s+", "_");
            if (TstTableWriter.matches(info, ID_INFO)) {
                idIndex = icol;
            }
            if (TstTableWriter.matches(info, RA_INFO)) {
                raIndex = icol;
            }
            if (TstTableWriter.matches(info, DEC_INFO)) {
                decIndex = icol;
            }
            if (TstTableWriter.matches(info, X_INFO)) {
                xIndex = icol;
            }
            if (!TstTableWriter.matches(info, Y_INFO)) continue;
            yIndex = icol;
        }
        TstTableWriter.printLine(out, "# Attempted guesses about identity of columns in the table.");
        TstTableWriter.printLine(out, "# These have been inferred from column UCDs and/or names");
        TstTableWriter.printLine(out, "# in the original table data.");
        TstTableWriter.printLine(out, "# The algorithm which identifies these columns is not particularly reliable,");
        TstTableWriter.printLine(out, "# so it is possible that these are incorrect.");
        TstTableWriter.printLine(out, "id_col: " + idIndex);
        TstTableWriter.printLine(out, "ra_col: " + raIndex);
        TstTableWriter.printLine(out, "dec_col: " + decIndex);
        if (xIndex >= 0) {
            TstTableWriter.printLine(out, "x_col: " + xIndex);
        }
        if (yIndex >= 0) {
            TstTableWriter.printLine(out, "y_col: " + yIndex);
        }
        TstTableWriter.printLine(out, "");
        TstTableWriter.printLine(out, "# This TST file generated by STIL v" + IOUtils.getResourceContents(StarTable.class, "stil.version", null));
        TstTableWriter.printLine(out, "");
        TstTableWriter.printRow(out, colNames);
        String[] separators = new String[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            separators[icol] = colNames[icol].replaceAll(".", "-");
        }
        TstTableWriter.printRow(out, separators);
        RowSequence rseq = st.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] srow = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    String sval = colInfos[icol].formatValue(row[icol], 10240);
                    srow[icol] = TstTableWriter.escapeText(sval);
                }
                TstTableWriter.printRow(out, srow);
            }
            TstTableWriter.printLine(out, "[EOD]");
        }
        finally {
            rseq.close();
        }
    }

    private static void printLine(OutputStream out, String line) throws IOException {
        out.write(TstTableWriter.getBytes(line));
        out.write(10);
    }

    private static void printRow(OutputStream out, String[] row) throws IOException {
        for (int icol = 0; icol < row.length; ++icol) {
            if (icol > 0) {
                out.write(9);
            }
            out.write(TstTableWriter.getBytes(row[icol]));
        }
        out.write(10);
    }

    private static byte[] getBytes(String str) {
        int leng = str.length();
        byte[] buf = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            buf[i] = (byte)str.charAt(i);
        }
        return buf;
    }

    private static StarTable prepareTable(StarTable in) {
        int ncol = in.getColumnCount();
        int raIndex = -1;
        int decIndex = -1;
        int idIndex = -1;
        int xIndex = -1;
        int yIndex = -1;
        double raFactor = 1.0;
        double decFactor = 1.0;
        for (int icol = 0; icol < ncol; ++icol) {
            String lunits;
            ColumnInfo info = in.getColumnInfo(icol);
            String name = info.getName();
            String ucd = info.getUCD();
            String units = info.getUnitString();
            Class clazz = info.getContentClass();
            String lucd = ucd == null ? "" : ucd.toLowerCase();
            String lname = name == null ? "" : name.toLowerCase();
            String string = lunits = units == null ? "" : units.toLowerCase();
            if (raIndex < 0 && (lucd.startsWith("pos.eq.ra") || lname.matches("ra_?(2000)?") || lname.matches("right.asc.*"))) {
                raIndex = icol;
                if (Number.class.isAssignableFrom(clazz) && lunits.startsWith("rad")) {
                    raFactor = 57.29577951308232;
                }
            }
            if (decIndex < 0 && (lucd.startsWith("pos.eq.dec") || lname.matches("dec?_?(2000)?") || lname.matches("decl?_?(2000)?") || lname.startsWith("declination"))) {
                decIndex = icol;
                if (Number.class.isAssignableFrom(clazz) && lunits.startsWith("rad")) {
                    decFactor = 57.29577951308232;
                }
            }
            if (idIndex < 0 && (lucd.startsWith("meta.id") || lucd.startsWith("id_") || lname.equals("id") || lname.startsWith("ident") || lname.equals("name"))) {
                idIndex = icol;
            }
            if (xIndex < 0 && (lucd.startsWith("pos.cartesian.x") || lname.equals("x") || lname.equals("xpos"))) {
                xIndex = icol;
            }
            if (yIndex >= 0 || !lucd.startsWith("pos.cartesian.y") && !lname.equals("y") && !lname.equals("ypos")) continue;
            yIndex = icol;
        }
        double[] factors = new double[ncol];
        Arrays.fill(factors, 1.0);
        if (raIndex >= 0) {
            factors[raIndex] = raFactor;
        }
        if (decIndex >= 0) {
            factors[decIndex] = decFactor;
        }
        StarTable out = new FactorStarTable(in, factors);
        if (idIndex < 0) {
            ColumnInfo indexInfo = new ColumnInfo("Index", Long.class, "Row index within table");
            ColumnData indexCol = new ColumnData(indexInfo){

                @Override
                public Object readValue(long irow) {
                    return new Long(irow + 1L);
                }
            };
            long ixCount = out.getRowCount();
            if (ixCount < 0L) {
                ixCount = Long.MAX_VALUE;
            }
            ColumnStarTable indexTable = ColumnStarTable.makeTableWithRows(ixCount);
            indexTable.addColumn(indexCol);
            idIndex = out.getColumnCount();
            JoinStarTable joined = new JoinStarTable(new StarTable[]{out, indexTable});
            joined.setName(out.getName());
            joined.setURL(out.getURL());
            joined.setParameters(out.getParameters());
            out = joined;
            assert (out.getColumnCount() == idIndex + 1);
        }
        String labelKey = LABEL_INFO.getName();
        if (idIndex >= 0) {
            out.getColumnInfo(idIndex).setAuxDatum(ID_INFO.getAuxDatumByName(labelKey));
        }
        if (raIndex >= 0) {
            out.getColumnInfo(raIndex).setAuxDatum(RA_INFO.getAuxDatumByName(labelKey));
        }
        if (decIndex >= 0) {
            out.getColumnInfo(decIndex).setAuxDatum(DEC_INFO.getAuxDatumByName(labelKey));
        }
        if (xIndex >= 0) {
            out.getColumnInfo(xIndex).setAuxDatum(X_INFO.getAuxDatumByName(labelKey));
        }
        if (yIndex >= 0) {
            out.getColumnInfo(yIndex).setAuxDatum(Y_INFO.getAuxDatumByName(labelKey));
        }
        return out;
    }

    private static boolean matches(ColumnInfo info1, ColumnInfo info2) {
        String labelKey = LABEL_INFO.getName();
        String label1 = (String)info1.getAuxDatumValueByName(labelKey, String.class);
        String label2 = (String)info2.getAuxDatumValueByName(labelKey, String.class);
        return label1 != null && label2 != null && label1.equals(label2);
    }

    private static String escapeText(String in) {
        int leng = in.length();
        boolean ok = true;
        for (int ic = 0; ic < leng; ++ic) {
            switch (in.charAt(ic)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    ok = false;
                }
            }
        }
        if (ok) {
            return in;
        }
        StringBuffer sbuf = new StringBuffer(in);
        for (int ic = 0; ic < leng; ++ic) {
            switch (in.charAt(ic)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    sbuf.setCharAt(ic, ' ');
                }
            }
        }
        return sbuf.toString();
    }

    static {
        ID_INFO.setAuxDatum(new DescribedValue(LABEL_INFO, "ID"));
        RA_INFO.setAuxDatum(new DescribedValue(LABEL_INFO, "RA"));
        DEC_INFO.setAuxDatum(new DescribedValue(LABEL_INFO, "DEC"));
        X_INFO.setAuxDatum(new DescribedValue(LABEL_INFO, "X"));
        Y_INFO.setAuxDatum(new DescribedValue(LABEL_INFO, "Y"));
    }

    private static class FactorStarTable
    extends WrapperStarTable {
        private final double[] factors_;
        private final ColumnInfo[] colInfos_;

        FactorStarTable(StarTable base, double[] factors) {
            super(base);
            this.factors_ = factors;
            int ncol = base.getColumnCount();
            this.colInfos_ = new ColumnInfo[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = new ColumnInfo(base.getColumnInfo(icol));
                if (factors[icol] != 1.0) {
                    info.setContentClass(Double.class);
                }
                this.colInfos_[icol] = info;
            }
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            Object val = super.getCell(lrow, icol);
            return this.factors_[icol] == 1.0 || val == null ? val : new Double(((Number)val).doubleValue() * this.factors_[icol]);
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            Object[] row = super.getRow(lrow);
            int ncol = row.length;
            for (int icol = 0; icol < ncol; ++icol) {
                Object val = row[icol];
                double factor = this.factors_[icol];
                if (factor == 1.0 || val == null) continue;
                row[icol] = new Double(((Number)val).doubleValue() * factor);
            }
            return row;
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            return new WrapperRowSequence(super.getRowSequence()){

                @Override
                public Object getCell(int icol) throws IOException {
                    Object val = super.getCell(icol);
                    return FactorStarTable.this.factors_[icol] == 1.0 || val == null ? val : new Double(((Number)val).doubleValue() * FactorStarTable.this.factors_[icol]);
                }

                @Override
                public Object[] getRow() throws IOException {
                    Object[] row = super.getRow();
                    int ncol = row.length;
                    for (int icol = 0; icol < ncol; ++icol) {
                        Object val = row[icol];
                        double factor = FactorStarTable.this.factors_[icol];
                        if (factor == 1.0 || val == null) continue;
                        row[icol] = new Double(((Number)val).doubleValue() * factor);
                    }
                    return row;
                }
            };
        }
    }
}

