/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.WDCTableBuilder;

class WDCReader {
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s*(\\S+)");
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table.formats");
    private ColumnInfo[] colinfos;
    private Eater[] eaters;

    public WDCReader(BufferedInputStream strm) throws IOException {
        String l1 = WDCTableBuilder.readLine(strm);
        if (l1 == null && !l1.startsWith("Column formats and units")) {
            throw new TableFormatException("Doesn't look quite like a WDC file");
        }
        String l2 = WDCTableBuilder.readLine(strm);
        if (l2 == null && !l2.startsWith("---")) {
            throw new TableFormatException("Doesn't look quite like a WDC file");
        }
        ArrayList<ColumnInfo> colinfoList = new ArrayList<ColumnInfo>();
        ArrayList<Eater> eaterList = new ArrayList<Eater>();
        while (true) {
            String line;
            if ((line = WDCTableBuilder.readLine(strm)) == null) {
                throw new TableFormatException("End of file in WDC headers");
            }
            if (line.toLowerCase().matches("^\\s*datetime.*yy+\\s+mm\\s+dd\\s+hhmmss.*")) {
                ColumnInfo colinfo = new ColumnInfo("Date", Date.class, "Date of observation");
                Eater eater = new Eater(){

                    @Override
                    public Object eat(Matcher matcher) {
                        Calendar cal = Calendar.getInstance();
                        matcher.find();
                        int year = Integer.parseInt(matcher.group(1));
                        cal.set(1, year);
                        matcher.find();
                        int month = Integer.parseInt(matcher.group(1));
                        cal.set(2, month);
                        matcher.find();
                        int day = -1 + Integer.parseInt(matcher.group(1));
                        cal.set(5, day);
                        matcher.find();
                        String hhmmss = matcher.group(1);
                        int hour = Integer.parseInt(hhmmss.substring(0, 2));
                        int min = Integer.parseInt(hhmmss.substring(2, 4));
                        int sec = Integer.parseInt(hhmmss.substring(4, 6));
                        cal.set(11, hour);
                        cal.set(12, min);
                        cal.set(13, sec);
                        return cal.getTime();
                    }
                };
                colinfoList.add(colinfo);
                eaterList.add(eater);
                continue;
            }
            if (line.matches("^\\s+%[0-9]+[a-z]\\s*$")) continue;
            if (line.matches("^\\S.*\\s%[0-9\\.\\+\\-]+[a-z]\\s+[^%]*$")) {
                Eater eater;
                Class clazz;
                Pattern pat = Pattern.compile("^(\\S.*?)\\s*%[0-9\\.\\+\\-]+([a-z]).*");
                Matcher matcher = pat.matcher(line);
                assert (matcher.find());
                String colname = matcher.group(1);
                char fmt = matcher.group(2).charAt(0);
                switch (fmt) {
                    case 'd': 
                    case 'i': {
                        clazz = Integer.class;
                        eater = new Eater(){

                            @Override
                            public Object eat(Matcher matcher) {
                                matcher.find();
                                String word = matcher.group(1);
                                return word.equals("-") ? null : Integer.valueOf(word);
                            }
                        };
                        break;
                    }
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        clazz = Float.class;
                        eater = new Eater(){

                            @Override
                            public Object eat(Matcher matcher) {
                                matcher.find();
                                String word = matcher.group(1);
                                return word.equals("-") ? null : Float.valueOf(word);
                            }
                        };
                        break;
                    }
                    case 's': {
                        clazz = String.class;
                        eater = new Eater(){

                            @Override
                            public Object eat(Matcher matcher) {
                                matcher.find();
                                String word = matcher.group(1);
                                return word;
                            }
                        };
                        break;
                    }
                    default: {
                        throw new TableFormatException("Unknown data format '" + fmt + "'");
                    }
                }
                colinfoList.add(new ColumnInfo(colname, clazz, null));
                eaterList.add(eater);
                continue;
            }
            if (line.trim().length() == 0) break;
            logger.warning("Ignoring strange format line \"" + line + "\"");
        }
        this.colinfos = colinfoList.toArray(new ColumnInfo[0]);
        this.eaters = eaterList.toArray(new Eater[0]);
        assert (this.colinfos.length == this.eaters.length);
    }

    public ColumnInfo[] getColumnInfos() {
        return this.colinfos;
    }

    public Object[] decodeLine(String line) {
        boolean ipos = false;
        int ncol = this.colinfos.length;
        Object[] row = new Object[ncol];
        Matcher matcher = SPACES_PATTERN.matcher(line);
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.eaters[icol].eat(matcher);
        }
        return row;
    }

    private static interface Eater {
        public Object eat(Matcher var1);
    }
}

