/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.WDCReader;
import uk.ac.starlink.table.formats.WDCStarTable;
import uk.ac.starlink.util.DataSource;

public class WDCTableBuilder
implements TableBuilder {
    @Override
    public String getFormatName() {
        return "WDC";
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        String start = new String(datsrc.getIntro());
        if (!start.startsWith("Column formats and units")) {
            throw new TableFormatException("Doesn't start \"Column formats and units\"");
        }
        BufferedInputStream strm = new BufferedInputStream(datsrc.getInputStream());
        WDCReader wdcReader = new WDCReader(strm);
        WDCStarTable st = new WDCStarTable(wdcReader, datsrc);
        st.setURL(datsrc.getURL());
        st.setName(datsrc.getName());
        return st;
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("WDC streaming not implemented");
    }

    public static String readLine(BufferedInputStream strm) throws IOException {
        StringBuffer sbuf = new StringBuffer();
        int c;
        while ((c = strm.read()) != -1) {
            if (c == 10) {
                return sbuf.toString();
            }
            sbuf.append((char)c);
        }
        return null;
    }
}

