/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.TableLoadDialog;

public abstract class AbstractTableLoadDialog
implements TableLoadDialog {
    private final String name_;
    private final String description_;
    private final FormatComboBoxModel formatSelectorModel_;
    private Component queryComponent_;
    private JMenu[] menus_;
    private Action[] toolbarActions_;
    private Icon icon_;
    private String[] formats_;
    private Action submitAct_;
    private boolean configured_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.gui");

    protected AbstractTableLoadDialog(String name, String description) {
        this.name_ = name;
        this.description_ = description;
        this.formats_ = new String[0];
        this.formatSelectorModel_ = new FormatComboBoxModel();
        this.menus_ = new JMenu[0];
        this.toolbarActions_ = new Action[0];
    }

    protected abstract Component createQueryComponent();

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    @Override
    public Icon getIcon() {
        return this.icon_;
    }

    @Override
    public Component getQueryComponent() {
        if (this.queryComponent_ == null) {
            if (!this.configured_) {
                logger_.warning("getQueryComponent called before configure");
            }
            this.queryComponent_ = this.createQueryComponent();
            this.updateReady();
        }
        return this.queryComponent_;
    }

    @Override
    public JMenu[] getMenus() {
        return this.menus_;
    }

    public void setMenus(JMenu[] menus) {
        this.menus_ = menus;
    }

    @Override
    public Action[] getToolbarActions() {
        return this.toolbarActions_;
    }

    protected void setToolbarActions(Action[] acts) {
        this.toolbarActions_ = acts;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public void setIcon(Icon icon) {
        this.icon_ = icon;
    }

    public void setIconUrl(URL iconUrl) {
        this.setIcon(iconUrl == null ? null : new ImageIcon(iconUrl));
    }

    @Override
    public void configure(StarTableFactory tfact, Action submitAct) {
        this.configured_ = true;
        FormatComboBoxModel fcm = this.formatSelectorModel_;
        fcm.fireAllRemoved();
        this.formats_ = tfact.getKnownFormats().toArray(new String[0]);
        fcm.fireAllAdded();
        if (fcm.getSelectedItem() == null && fcm.getSize() > 0) {
            fcm.setSelectedItem(fcm.getElementAt(0));
        }
        this.submitAct_ = submitAct;
    }

    public JComboBox createFormatSelector() {
        return new JComboBox(this.formatSelectorModel_);
    }

    public String getSelectedFormat() {
        return (String)this.formatSelectorModel_.getSelectedItem();
    }

    @Override
    public Action getSubmitAction() {
        return this.submitAct_;
    }

    public boolean isComponentShowing() {
        Window container = this.queryComponent_ == null ? null : (Window)SwingUtilities.getAncestorOfClass(Window.class, this.queryComponent_);
        return container != null && container.isShowing();
    }

    protected void submit() {
        this.getSubmitAction().actionPerformed(new ActionEvent(this, 0, "Submit"));
    }

    protected void updateReady() {
        this.getSubmitAction().setEnabled(this.isReady());
    }

    public boolean isReady() {
        return true;
    }

    public static IOException asIOException(Throwable th) {
        if (th instanceof IOException) {
            return (IOException)th;
        }
        String msg = th.getMessage();
        if (msg != null) {
            msg = th.getClass().getName();
        }
        return (IOException)new IOException(msg).initCause(th);
    }

    private class FormatComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selected_;

        private FormatComboBoxModel() {
        }

        @Override
        public Object getElementAt(int ix) {
            return ix == 0 ? "(auto)" : AbstractTableLoadDialog.this.formats_[ix - 1];
        }

        @Override
        public int getSize() {
            return AbstractTableLoadDialog.this.formats_.length + 1;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selected_ = item;
        }

        void fireAllRemoved() {
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        void fireAllAdded() {
            this.fireIntervalAdded(this, 0, this.getSize());
        }
    }
}

