/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.gui.AbstractTableLoadDialog;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class FileChooserTableLoadDialog
extends AbstractTableLoadDialog {
    private JFileChooser chooser_;
    private Boolean isAvailable_;

    public FileChooserTableLoadDialog() {
        super("File Browser", "Load tables from files on the local filesystem");
        this.setIconUrl(StarTable.class.getResource("gui/filechooser.png"));
    }

    @Override
    protected Component createQueryComponent() {
        this.chooser_ = new JFileChooser();
        this.chooser_.setFileSelectionMode(0);
        this.chooser_.setMultiSelectionEnabled(false);
        this.chooser_.setCurrentDirectory(new File("."));
        this.chooser_.setControlButtonsAreShown(false);
        Box labelLine = Box.createHorizontalBox();
        labelLine.add(new JLabel("Format: "));
        labelLine.add(Box.createHorizontalGlue());
        Box selectorLine = Box.createHorizontalBox();
        selectorLine.add(new ShrinkWrapper(this.createFormatSelector()));
        selectorLine.add(Box.createHorizontalGlue());
        Box formatBox = Box.createVerticalBox();
        formatBox.add(Box.createVerticalGlue());
        formatBox.add(labelLine);
        formatBox.add(selectorLine);
        formatBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.chooser_.setAccessory(formatBox);
        this.chooser_.addActionListener(this.getSubmitAction());
        this.chooser_.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                FileChooserTableLoadDialog.this.chooser_.rescanCurrentDirectory();
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }
        });
        return this.chooser_;
    }

    @Override
    public TableLoader createTableLoader() {
        final File file = this.chooser_.getSelectedFile();
        if (file == null) {
            return null;
        }
        final String format = this.getSelectedFormat();
        return new TableLoader(){

            @Override
            public String getLabel() {
                return file.getName();
            }

            @Override
            public TableSequence loadTables(StarTableFactory tfact) throws IOException {
                return tfact.makeStarTables(new FileDataSource(file), format);
            }
        };
    }

    @Override
    public boolean isAvailable() {
        if (this.isAvailable_ == null) {
            try {
                SecurityManager manager = System.getSecurityManager();
                if (manager != null) {
                    manager.checkRead(new JFileChooser().getCurrentDirectory().toString());
                }
                this.isAvailable_ = Boolean.TRUE;
            }
            catch (SecurityException e) {
                this.isAvailable_ = Boolean.FALSE;
            }
        }
        return this.isAvailable_;
    }
}

