/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.io.IOException;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ProgressBarStarTable
extends WrapperStarTable {
    private JProgressBar progBar_;
    private String label_;

    public ProgressBarStarTable(StarTable baseTable) {
        this(baseTable, new JProgressBar());
    }

    public ProgressBarStarTable(StarTable baseTable, JProgressBar progBar) {
        super(baseTable);
        this.setProgressBar(progBar);
    }

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public void setActiveLabel(String label) {
        this.label_ = label;
        this.progBar_.setStringPainted(label != null && label.trim().length() > 0);
    }

    public String getActiveLabel() {
        return this.label_;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        long nrow = this.getRowCount();
        final long every = nrow > 0L ? nrow / 200L : 256L;
        this.setZero(true);
        return new WrapperRowSequence(this.baseTable.getRowSequence()){
            long counter;
            int irow;
            Runnable updater;
            {
                super(x0);
                this.updater = new Runnable(){

                    @Override
                    public void run() {
                        ProgressBarStarTable.this.progBar_.setValue(irow);
                    }
                };
            }

            @Override
            public boolean next() throws IOException {
                ++this.irow;
                if (--this.counter < 0L) {
                    SwingUtilities.invokeLater(this.updater);
                    this.counter = every;
                }
                if (Thread.interrupted()) {
                    throw new IOException("Operation interrupted");
                }
                return super.next();
            }

            @Override
            public void close() throws IOException {
                ProgressBarStarTable.this.setZero(false);
                super.close();
            }
        };
    }

    private void setZero(final boolean labelOn) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressBarStarTable.this.progBar_.setMinimum(0);
                ProgressBarStarTable.this.progBar_.setValue(0);
                long nrow = ProgressBarStarTable.this.getRowCount();
                boolean determinate = nrow > 0L && nrow < Integer.MAX_VALUE;
                ProgressBarStarTable.this.progBar_.setIndeterminate(!determinate);
                if (determinate) {
                    ProgressBarStarTable.this.progBar_.setMaximum((int)nrow);
                }
                ProgressBarStarTable.this.progBar_.setString(labelOn ? ProgressBarStarTable.this.label_ : "");
            }
        });
    }
}

