/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;

public class ProgressBarTableSink
implements TableSink {
    private final JProgressBar progBar_;
    private final Timer timer_;
    private int itab_;
    private long irow_;
    private long nrow_;

    public ProgressBarTableSink(JProgressBar progBar) {
        this(progBar, 100, 1);
    }

    public ProgressBarTableSink(JProgressBar progBar, int updateMillis, final int showTableIndex) {
        this.progBar_ = progBar;
        this.timer_ = new Timer(updateMillis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressBarTableSink.this.progBar_.setValue((int)Math.min(ProgressBarTableSink.this.irow_, Integer.MAX_VALUE));
                StringBuffer sbuf = new StringBuffer();
                if (ProgressBarTableSink.this.itab_ > showTableIndex && showTableIndex >= 0) {
                    sbuf.append(ProgressBarTableSink.this.itab_).append(": ");
                }
                sbuf.append(ProgressBarTableSink.this.irow_);
                if (ProgressBarTableSink.this.nrow_ > 0L) {
                    sbuf.append(" / ").append(ProgressBarTableSink.this.nrow_);
                }
                ProgressBarTableSink.this.progBar_.setString(sbuf.toString());
            }
        });
    }

    @Override
    public void acceptMetadata(StarTable meta) {
        ++this.itab_;
        this.irow_ = 0L;
        this.nrow_ = meta.getRowCount();
        this.progBar_.setMinimum(0);
        this.progBar_.setValue(0);
        if (this.nrow_ > 0L) {
            this.progBar_.setMaximum((int)Math.min(this.nrow_, Integer.MAX_VALUE));
        }
        this.progBar_.setIndeterminate(this.nrow_ <= 0L);
        this.timer_.start();
    }

    @Override
    public void acceptRow(Object[] row) {
        ++this.irow_;
    }

    @Override
    public void endRows() {
        this.timer_.stop();
        this.progBar_.setIndeterminate(false);
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    public void dispose() {
        this.timer_.stop();
        this.progBar_.setString("");
        this.progBar_.setValue(0);
        this.progBar_.setIndeterminate(false);
    }
}

