/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.BooleanCellRenderer;
import uk.ac.starlink.table.gui.NumericCellRenderer;
import uk.ac.starlink.table.gui.ValueInfoCellEditor;
import uk.ac.starlink.table.gui.ValueInfoCellRenderer;

public class StarTableColumn
extends TableColumn {
    private ColumnInfo colinfo;

    public StarTableColumn(ColumnInfo colinfo, int modelIndex) {
        super(modelIndex);
        this.colinfo = colinfo;
        this.setCellRenderer(StarTableColumn.createCellRenderer(colinfo));
        this.setCellEditor(StarTableColumn.createCellEditor(colinfo));
        this.setHeaderValue(colinfo.getName());
    }

    public StarTableColumn(ColumnInfo colinfo) {
        this(colinfo, 0);
    }

    public ColumnInfo getColumnInfo() {
        return this.colinfo;
    }

    public static TableCellRenderer createCellRenderer(ValueInfo info) {
        Class clazz = info.getContentClass();
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericCellRenderer(clazz);
        }
        if (clazz.equals(Boolean.class)) {
            return BooleanCellRenderer.getInstance();
        }
        return new ValueInfoCellRenderer(info);
    }

    public static TableCellEditor createCellEditor(ValueInfo info) {
        return ValueInfoCellEditor.makeEditor(info);
    }
}

