/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.event.ActionEvent;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.gui.ProgressBarTableSink;
import uk.ac.starlink.table.gui.TableLoadClient;
import uk.ac.starlink.table.gui.TableLoader;
import uk.ac.starlink.table.storage.MonitorStoragePolicy;

public class TableLoadWorker
extends Thread {
    private final TableLoader loader_;
    private final TableLoadClient client_;
    private final Action cancelAct_;
    private final StarTableFactory tfact_;
    private final ProgressBarTableSink progSink_;
    private final MonitorStoragePolicy policy_;
    private final JProgressBar progBar_;
    private boolean finished_;

    public TableLoadWorker(TableLoader loader, TableLoadClient client, JProgressBar progBar) {
        this.loader_ = loader;
        this.client_ = client;
        this.progBar_ = progBar;
        this.cancelAct_ = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableLoadWorker.this.cancel();
            }
        };
        this.tfact_ = new StarTableFactory(client.getTableFactory());
        this.progSink_ = new ProgressBarTableSink(progBar);
        this.policy_ = new MonitorStoragePolicy(this.tfact_.getStoragePolicy(), this.progSink_);
        this.tfact_.setStoragePolicy(this.policy_);
    }

    public TableLoadWorker(TableLoader loader, TableLoadClient client) {
        this(loader, client, TableLoadWorker.createDefaultProgressBar());
    }

    public TableLoader getLoader() {
        return this.loader_;
    }

    public TableLoadClient getLoadClient() {
        return this.client_;
    }

    public Action getCancelAction() {
        return this.cancelAct_;
    }

    public JProgressBar getProgressBar() {
        return this.progBar_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean ok;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableLoadWorker.this.client_.startSequence();
                TableLoadWorker.this.client_.setLabel(TableLoadWorker.this.loader_.getLabel());
            }
        });
        TableSequence tseq = null;
        try {
            tseq = this.loader_.loadTables(this.tfact_);
            ok = true;
        }
        catch (Throwable error) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TableLoadWorker.this.finished_) {
                        boolean interrupted = TableLoadWorker.isInterruption(error);
                        if (!interrupted) {
                            TableLoadWorker.this.client_.loadFailure(error);
                        }
                        TableLoadWorker.this.finish(interrupted);
                    }
                }
            });
            ok = false;
        }
        if (!ok) return;
        boolean more = true;
        try {
            while (!this.finished_ && more) {
                boolean endSeq;
                StarTable table = null;
                Throwable error = null;
                try {
                    table = tseq.nextTable();
                    endSeq = table == null;
                }
                catch (Throwable e) {
                    error = e;
                    endSeq = false;
                }
                if (!endSeq) {
                    final StarTable table1 = table;
                    final Throwable error1 = error;
                    final Boolean[] moreHolder = new Boolean[1];
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            boolean more;
                            if (table1 != null) {
                                more = TableLoadWorker.this.client_.loadSuccess(table1);
                            } else {
                                assert (error1 != null);
                                if (TableLoadWorker.isInterruption(error1)) {
                                    if (!TableLoadWorker.this.finished_) {
                                        TableLoadWorker.this.finish(true);
                                    }
                                    more = false;
                                } else {
                                    more = TableLoadWorker.this.client_.loadFailure(error1);
                                }
                            }
                            moreHolder[0] = more;
                        }
                    });
                    more = more && moreHolder[0] != false;
                    continue;
                }
                more = false;
            }
        }
        catch (InvocationTargetException e) {
            try {
                throw new RuntimeException(e);
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!TableLoadWorker.this.finished_) {
                            TableLoadWorker.this.finish(false);
                        }
                    }
                });
                throw throwable;
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void cancel() {
        if (!this.finished_) {
            this.finish(true);
        }
    }

    protected void finish(boolean cancelled) {
        assert (!this.finished_);
        this.finished_ = true;
        this.client_.endSequence(cancelled);
        if (cancelled) {
            this.policy_.interrupt();
        }
        this.progSink_.dispose();
    }

    private static boolean isInterruption(Throwable error) {
        for (Throwable err = error; err != null; err = err.getCause()) {
            if (!(err instanceof InterruptedException) && !(err instanceof InterruptedIOException)) continue;
            return true;
        }
        return false;
    }

    private static JProgressBar createDefaultProgressBar() {
        JProgressBar progBar = new JProgressBar();
        progBar.setString("");
        progBar.setStringPainted(true);
        return progBar;
    }
}

