/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.gui.StarJTable;

public class TableRowHeader
extends JTable {
    private JTable masterTable;
    private AbstractTableModel rowModel;
    private TableModel masterModel;
    private TableModelListener listener;

    public TableRowHeader(JTable table) {
        this.masterTable = table;
        this.masterModel = this.masterTable.getModel();
        this.rowModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableRowHeader.this.masterTable.getRowCount();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int irow, int icol) {
                return new Long(TableRowHeader.this.rowNumber(irow)) + "  ";
            }
        };
        this.setModel(this.rowModel);
        this.setSelectionModel(this.masterTable.getSelectionModel());
        this.listener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                TableRowHeader.this.rowModel.fireTableDataChanged();
            }
        };
        this.masterModel.addTableModelListener(this.listener);
        this.setTableHeader(null);
        this.setAutoResizeMode(0);
        this.setPreferredScrollableViewportSize(this.masterTable.getPreferredSize());
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        DefaultTableCellRenderer rend = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
        rend.setFont(UIManager.getFont("TableHeader.font"));
        rend.setBackground(UIManager.getColor("TableHeader.background"));
        rend.setForeground(UIManager.getColor("TableHeader.foreground"));
        rend.setHorizontalAlignment(4);
        TableColumn col = new TableColumn(0, 64, rend, null){
            Integer prefWidth_;

            @Override
            public void setPreferredWidth(int width) {
                this.prefWidth_ = new Integer(width);
            }

            @Override
            public int getPreferredWidth() {
                if (this.prefWidth_ != null) {
                    return this.prefWidth_;
                }
                TableRowHeader tab = TableRowHeader.this;
                int nrow = TableRowHeader.this.masterTable.getRowCount();
                if (nrow > 0) {
                    int first = StarJTable.getCellWidth(tab, 0, 0);
                    int last = StarJTable.getCellWidth(tab, nrow - 1, 0);
                    int guess = tab.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)tab, (Object)new StringBuilder().append((Object)new Long((long)((long)(nrow + 1)))).append((String)"  ").toString(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                    return 8 + Math.max(Math.max(first, last), guess);
                }
                return 64;
            }
        };
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        tcm.addColumn(col);
        this.setColumnModel(tcm);
    }

    public void setLongestNumber(long num) {
        int width = this.getCellRenderer((int)0, (int)0).getTableCellRendererComponent((JTable)this, (Object)new StringBuilder().append((Object)new Long((long)num)).append((String)" ").toString(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 8;
        this.getColumnModel().getColumn(0).setPreferredWidth(width);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void modelChanged() {
        TableModel mmodel = this.masterTable.getModel();
        if (mmodel != this.masterModel) {
            this.masterModel.removeTableModelListener(this.listener);
            this.masterModel = mmodel;
            this.masterModel.addTableModelListener(this.listener);
        }
        this.rowModel.fireTableDataChanged();
    }

    public long rowNumber(int irow) {
        return irow + 1;
    }

    public void installOnScroller(final JScrollPane scroller) {
        scroller.setRowHeaderView(this);
        final JViewport rhView = scroller.getRowHeader();
        rhView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                int iExtent = rhView.getExtentSize().height;
                int iMax = rhView.getViewSize().height;
                int iPos = rhView.getViewPosition().y;
                int iValue = Math.max(0, Math.min(iPos, iMax - iExtent));
                scroller.getVerticalScrollBar().setValues(iValue, iExtent, 0, iMax);
            }
        });
    }
}

