/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import uk.ac.starlink.connect.FilestoreChooser;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.gui.FilestoreTableSaveDialog;
import uk.ac.starlink.table.gui.SaveWorker;
import uk.ac.starlink.table.gui.SystemTableSaveDialog;
import uk.ac.starlink.table.gui.TableSaveDialog;

public abstract class TableSaveChooser
extends JPanel {
    private final JComboBox formatSelector_;
    private final JComponent[] activeComponents_;
    private final FilestoreChooser filestoreChooser_;
    private final List activeActionList_;
    private final Action[] tsdActions_;
    private StarTableOutput sto_;
    private JDialog dialog_;
    private JProgressBar progBar_;
    private SaveWorker worker_;

    public TableSaveChooser() {
        this(new StarTableOutput(), new TableSaveDialog[]{new FilestoreTableSaveDialog(), new SystemTableSaveDialog()});
    }

    public TableSaveChooser(StarTableOutput sto, TableSaveDialog[] saveDialogs) {
        super(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Box actionBox = Box.createVerticalBox();
        actionBox.setBorder(emptyBorder);
        this.add((Component)actionBox, "Center");
        ArrayList<JComponent> activeList = new ArrayList<JComponent>();
        this.activeActionList_ = new ArrayList();
        Box formatBox = Box.createHorizontalBox();
        formatBox.add(new JLabel("Output Format: "));
        this.formatSelector_ = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        formatBox.add(this.formatSelector_);
        activeList.add(this.formatSelector_);
        formatBox.setAlignmentX(0.0f);
        actionBox.add(formatBox);
        this.setTableOutput(sto);
        final JTextField locField = new JTextField(25);
        AbstractAction locAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSaveChooser.this.submitLocation(locField.getText());
            }
        };
        this.activeActionList_.add(locAction);
        Box locBox = Box.createHorizontalBox();
        locField.addActionListener(locAction);
        locBox.add(new JLabel("Location: "));
        locBox.add(locField);
        activeList.add(locField);
        Dimension locSize = locBox.getPreferredSize();
        locSize.width = 1024;
        locBox.setMaximumSize(locSize);
        locBox.setAlignmentX(0.0f);
        locBox.add(Box.createHorizontalStrut(5));
        locBox.add(new JButton(locAction));
        actionBox.add(Box.createVerticalStrut(5));
        actionBox.add(locBox);
        FilestoreTableSaveDialog fsd = null;
        for (int i = 0; fsd == null && i < saveDialogs.length; ++i) {
            if (!(saveDialogs[i] instanceof FilestoreTableSaveDialog)) continue;
            fsd = (FilestoreTableSaveDialog)saveDialogs[i];
        }
        if (fsd == null) {
            fsd = new FilestoreTableSaveDialog();
        }
        this.filestoreChooser_ = fsd.getChooser();
        ArrayList<JButton> buttList = new ArrayList<JButton>();
        ArrayList<Action> tsdActionList = new ArrayList<Action>();
        for (int i = 0; i < saveDialogs.length; ++i) {
            Action tsdAction = this.createSaveDialogAction(saveDialogs[i]);
            tsdActionList.add(tsdAction);
            buttList.add(new JButton(tsdAction));
        }
        JButton[] buttons = buttList.toArray(new JButton[0]);
        this.tsdActions_ = tsdActionList.toArray(new Action[0]);
        int nopt = buttons.length;
        int buttw = 0;
        for (int i = 0; i < nopt; ++i) {
            buttw = Math.max(buttw, buttons[i].getPreferredSize().width);
        }
        Box dialogBox = Box.createVerticalBox();
        for (int i = 0; i < nopt; ++i) {
            Dimension max = buttons[i].getMaximumSize();
            max.width = buttw;
            buttons[i].setMaximumSize(max);
            if (i > 0) {
                dialogBox.add(Box.createVerticalStrut(5));
            }
            dialogBox.add(buttons[i]);
        }
        JPanel dialogLine = new JPanel(new FlowLayout(2, 0, 0));
        dialogLine.add(dialogBox);
        dialogLine.setAlignmentX(0.0f);
        actionBox.add(Box.createVerticalStrut(10));
        actionBox.add(dialogLine);
        this.activeComponents_ = activeList.toArray(new JComponent[0]);
    }

    FilestoreChooser getFilestoreChooser() {
        return this.filestoreChooser_;
    }

    public void setTableOutput(StarTableOutput sto) {
        this.sto_ = sto;
        this.formatSelector_.setModel(TableSaveChooser.makeFormatBoxModel(sto, false));
    }

    public StarTableOutput getTableOutput() {
        return this.sto_;
    }

    public JComboBox getFormatSelector() {
        return this.formatSelector_;
    }

    public abstract StarTable[] getTables();

    public void setProgressBar(JProgressBar progBar) {
        this.progBar_ = progBar;
    }

    private JProgressBar getProgressBar() {
        return this.progBar_ == null ? new JProgressBar() : this.progBar_;
    }

    public Action[] getSaveDialogActions() {
        return this.tsdActions_;
    }

    public void done() {
        if (this.dialog_ != null) {
            this.dialog_.dispose();
        }
        this.filestoreChooser_.refreshList();
    }

    private void cancel() {
        if (this.worker_ != null) {
            this.worker_.cancel();
            this.worker_ = null;
            this.setEnabled(true);
        } else if (this.dialog_ != null) {
            this.dialog_.dispose();
            this.dialog_ = null;
        }
    }

    public void showSaveDialog(Component parent) {
        this.dialog_ = this.createDialog(parent);
        this.setProgressBar(new JProgressBar());
        this.dialog_.getContentPane().add((Component)this.progBar_, "South");
        this.setEnabled(true);
        this.dialog_.pack();
        this.dialog_.setVisible(true);
        this.dialog_ = null;
        this.setProgressBar(null);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            for (int i = 0; i < this.activeComponents_.length; ++i) {
                this.activeComponents_[i].setEnabled(isEnabled);
            }
            Iterator it = this.activeActionList_.iterator();
            while (it.hasNext()) {
                ((Action)it.next()).setEnabled(isEnabled);
            }
        }
        super.setEnabled(isEnabled);
    }

    public String getSelectedFormat() {
        return (String)this.formatSelector_.getSelectedItem();
    }

    public void setSelectedFormat(String format) {
        this.formatSelector_.setSelectedItem(format);
    }

    public JDialog createDialog(Component parent) {
        Frame frame = null;
        if (parent != null) {
            frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        }
        JDialog dialog = new JDialog(frame, "Save Table", true);
        dialog.setDefaultCloseOperation(2);
        JPanel pane = new JPanel(new BorderLayout());
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)pane, "Center");
        pane.setLayout(new BorderLayout());
        pane.add((Component)this, "Center");
        Box iconBox = Box.createVerticalBox();
        iconBox.add(Box.createVerticalGlue());
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.questionIcon")));
        iconBox.add(Box.createVerticalGlue());
        iconBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)iconBox, "West");
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSaveChooser.this.cancel();
            }
        };
        Box cancelBox = Box.createHorizontalBox();
        cancelBox.add(Box.createHorizontalGlue());
        cancelBox.add(new JButton(cancelAction));
        cancelBox.add(Box.createHorizontalGlue());
        cancelBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)cancelBox, "South");
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public final Action createSaveDialogAction(final TableSaveDialog tsd) {
        final TableSaveChooser chooser = this;
        AbstractAction tsdAction = new AbstractAction(tsd.getName()){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (tsd.showSaveDialog(chooser, chooser.getTableOutput(), chooser.formatSelector_.getModel(), chooser.getTables())) {
                    chooser.done();
                }
            }
        };
        tsdAction.putValue("ShortDescription", tsd.getDescription());
        tsdAction.putValue("SmallIcon", tsd.getIcon());
        tsdAction.setEnabled(tsd.isAvailable());
        if (tsdAction.isEnabled()) {
            this.activeActionList_.add(tsdAction);
        }
        return tsdAction;
    }

    private void submitLocation(final String loc) {
        final StarTableOutput sto = this.getTableOutput();
        final String format = this.getSelectedFormat();
        this.worker_ = new SaveWorker(this.getProgressBar(), this.getTables(), loc){

            @Override
            protected void attemptSave(StarTable[] tables) throws IOException {
                sto.writeStarTables(tables, loc, format);
            }

            @Override
            protected void done(boolean success) {
                if (success) {
                    TableSaveChooser.this.done();
                }
                TableSaveChooser.this.worker_ = null;
                TableSaveChooser.this.setEnabled(true);
            }
        };
        this.setEnabled(false);
        this.worker_.invoke();
    }

    public static ComboBoxModel makeFormatBoxModel(StarTableOutput sto, boolean multi) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("(auto)");
        for (StarTableWriter handler : sto.getHandlers()) {
            if (multi && !(handler instanceof MultiStarTableWriter)) continue;
            model.addElement(handler.getFormatName());
        }
        return model;
    }

    public static void main(String[] args) {
        final int nrow = Integer.parseInt(args[0]);
        final ColumnStarTable tab = new ColumnStarTable(){

            @Override
            public long getRowCount() {
                return nrow;
            }
        };
        tab.addColumn(new ColumnData(new ColumnInfo("index", Integer.class, null)){

            @Override
            public Object readValue(long irow) {
                return new Integer((int)(irow + 1L));
            }
        });
        new TableSaveChooser(){

            @Override
            public StarTable[] getTables() {
                return new StarTable[]{tab};
            }
        }.showSaveDialog(null);
        System.exit(0);
    }
}

