/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.gui;

import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import uk.ac.starlink.table.ValueInfo;

public class ValueInfoCellEditor {
    public static TableCellEditor makeEditor(final ValueInfo vinfo) {
        Class clazz = vinfo.getContentClass();
        if (clazz == Boolean.class) {
            return new DefaultCellEditor(new JCheckBox()){

                @Override
                public boolean stopCellEditing() {
                    try {
                        return super.stopCellEditing();
                    }
                    catch (Exception e) {
                        ValueInfoCellEditor.copeWithException(e);
                        this.cancelCellEditing();
                        return true;
                    }
                }
            };
        }
        final JTextField tfield = new JTextField();
        return new DefaultCellEditor(tfield){

            @Override
            public Object getCellEditorValue() {
                return vinfo.unformatString(tfield.getText());
            }

            @Override
            public boolean stopCellEditing() {
                try {
                    return super.stopCellEditing();
                }
                catch (Exception e) {
                    ValueInfoCellEditor.copeWithException(e);
                    this.cancelCellEditing();
                    return true;
                }
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int irow, int icol) {
                String renderedValue = vinfo.formatValue(value, 10240);
                return super.getTableCellEditorComponent(table, renderedValue, isSelected, irow, icol);
            }
        };
    }

    private static void copeWithException(Exception e) {
        Toolkit.getDefaultToolkit().beep();
    }
}

