/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.Connector;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCFormatter;
import uk.ac.starlink.table.jdbc.JDBCStarTable;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;
import uk.ac.starlink.table.jdbc.WriteMode;

public class JDBCHandler {
    private JDBCAuthenticator auth;
    private String user;
    private String passwd;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");

    public JDBCHandler() {
        this(new TerminalAuthenticator());
    }

    public JDBCHandler(JDBCAuthenticator auth) {
        this.auth = auth;
    }

    public JDBCHandler(JDBCHandler jh) {
        this(jh.auth);
    }

    public JDBCAuthenticator getAuthenticator() {
        return this.auth;
    }

    public void setAuthenticator(JDBCAuthenticator auth) {
        auth.getClass();
        this.auth = auth;
    }

    public StarTable makeStarTable(String spec, boolean wantRandom) throws IOException {
        if (!spec.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Not a JDBC-protocol URL");
        }
        int hashPos = (spec = JDBCHandler.unEscape(spec)).indexOf("#");
        if (hashPos < 0) {
            throw new IOException("Bad JDBC specification, should be jdbc:...#SQL-query");
        }
        String frag = spec.substring(hashPos + 1);
        final String url = spec.substring(0, hashPos);
        try {
            Connector connector = new Connector(){

                @Override
                public Connection getConnection() throws SQLException {
                    try {
                        Connection conn = JDBCHandler.this.getConnection(url);
                        DatabaseMetaData meta = conn.getMetaData();
                        logger_.info("JDBC Connection to " + meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion() + " " + "with driver " + meta.getDriverName() + " " + meta.getDriverVersion());
                        return conn;
                    }
                    catch (IOException e) {
                        throw (SQLException)new SQLException("Authentication failed").initCause(e);
                    }
                }
            };
            try {
                return new JDBCStarTable(connector, frag, wantRandom);
            }
            catch (SQLException e) {
                if (wantRandom) {
                    return new JDBCStarTable(connector, frag, false);
                }
                throw e;
            }
        }
        catch (SQLException e) {
            StringBuffer sbuf = new StringBuffer().append("Error making connection ").append(url);
            Enumeration<Driver> den = DriverManager.getDrivers();
            if (den.hasMoreElements()) {
                sbuf.append(" - known JDBC drivers:\n");
                while (den.hasMoreElements()) {
                    sbuf.append("   ").append(den.nextElement().getClass().getName()).append('\n');
                }
            } else {
                sbuf.append(" - no known JDBC drivers");
            }
            throw (IOException)new IOException(sbuf.toString()).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJDBCTable(StarTable startab, String spec, WriteMode mode) throws IOException, SQLException {
        if (!spec.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Not a JDBC-protocol URL");
        }
        int hashPos = spec.indexOf("#");
        if (hashPos < 0) {
            throw new IOException("Bad JDBC specification, should be \"jdbc:...#table-name\"");
        }
        String frag = spec.substring(hashPos + 1);
        String url = spec.substring(0, hashPos);
        Connection conn = this.getConnection(url);
        try {
            new JDBCFormatter(conn, startab).createJDBCTable(frag, mode);
        }
        finally {
            conn.close();
        }
    }

    private Connection getConnection(String url) throws IOException, SQLException {
        try {
            return DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            String[] authInfo = this.auth.authenticate();
            this.user = authInfo[0];
            this.passwd = authInfo[1];
            return DriverManager.getConnection(url, this.user, this.passwd);
        }
    }

    public static boolean hasDrivers() {
        return DriverManager.getDrivers().hasMoreElements();
    }

    private static String unEscape(String url) {
        StringBuffer buf = new StringBuffer();
        Matcher m = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]").matcher(url);
        while (m.find()) {
            char c = (char)Integer.parseInt(m.group().substring(1, 3), 16);
            m.appendReplacement(buf, new String(new char[]{c}));
        }
        m.appendTail(buf);
        return buf.toString();
    }
}

