/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.jdbc.Connector;
import uk.ac.starlink.table.jdbc.JDBCUtils;
import uk.ac.starlink.table.jdbc.StarResultSet;
import uk.ac.starlink.table.jdbc.TypeMappers;

public class JDBCStarTable
extends AbstractStarTable {
    private ColumnInfo[] colInfos_;
    private final Connector connx_;
    private final String sql_;
    private StarResultSet randomSet_;
    private static final ValueInfo SQL_INFO = new DefaultValueInfo("SQL", String.class, "SQL query text");
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");

    public JDBCStarTable(Connector connx, String sql) throws SQLException {
        this(connx, sql, false);
        this.getParameters().add(new DescribedValue(SQL_INFO, sql));
    }

    public JDBCStarTable(Connector connx, String sql, boolean isRandom) throws SQLException {
        Statement stmt;
        this.connx_ = connx;
        this.sql_ = sql;
        Connection conn = connx.getConnection();
        this.setName(conn.getMetaData().getURL() + '#' + sql);
        if (isRandom) {
            stmt = conn.createStatement(1004, 1007);
            this.randomSet_ = new StarResultSet(JDBCStarTable.makeRandomResultSet(conn, sql));
        }
        if (isRandom) {
            this.colInfos_ = this.randomSet_.getColumnInfos();
        } else {
            stmt = JDBCUtils.createStreamingStatement(conn, false);
            stmt.setMaxRows(1);
            ResultSet rset = stmt.executeQuery(sql);
            this.colInfos_ = new StarResultSet(rset).getColumnInfos();
            rset.close();
        }
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    @Override
    public List getColumnAuxDataInfos() {
        return TypeMappers.STANDARD.getColumnAuxDataInfos();
    }

    @Override
    public int getColumnCount() {
        return this.colInfos_.length;
    }

    @Override
    public long getRowCount() {
        return this.randomSet_ == null ? -1L : this.randomSet_.getRowCount();
    }

    public void setRandom() throws SQLException {
        if (this.randomSet_ == null) {
            this.randomSet_ = new StarResultSet(JDBCStarTable.makeRandomResultSet(this.connx_.getConnection(), this.sql_));
            this.checkConsistent(this.randomSet_);
        }
    }

    @Override
    public boolean isRandom() {
        return this.randomSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCell(long lrow, int icol) throws IOException {
        if (this.randomSet_ == null) {
            throw new UnsupportedOperationException("No random access");
        }
        StarResultSet starResultSet = this.randomSet_;
        synchronized (starResultSet) {
            this.randomSet_.setRowIndex(lrow);
            return this.randomSet_.getCell(icol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getRow(long lrow) throws IOException {
        if (this.randomSet_ == null) {
            throw new UnsupportedOperationException("No random access");
        }
        StarResultSet starResultSet = this.randomSet_;
        synchronized (starResultSet) {
            this.randomSet_.setRowIndex(lrow);
            return this.randomSet_.getRow();
        }
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        StarResultSet srset;
        Connection conn = null;
        try {
            conn = this.connx_.getConnection();
            Statement stmt = JDBCUtils.createStreamingStatement(conn, false);
            srset = new StarResultSet(stmt.executeQuery(this.sql_));
            this.checkConsistent(srset);
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (OutOfMemoryError e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            String msg = "Out of memory during SQL statement execution; looks like JDBC driver is assembling a read-only ResultSet in memory on the client, which is questionable behaviour";
            throw (OutOfMemoryError)new OutOfMemoryError(msg).initCause(e);
        }
        assert (conn != null);
        final Connection connection = conn;
        return new WrapperRowSequence(srset.createRowSequence()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        };
    }

    public Connection getConnection() throws SQLException {
        return this.connx_.getConnection();
    }

    public String getSql() {
        return this.sql_;
    }

    private static ResultSet makeRandomResultSet(Connection conn, String sql) throws SQLException {
        return conn.createStatement(1004, 1007).executeQuery(sql);
    }

    private void checkConsistent(StarResultSet srset) throws SQLException {
        if (srset.getColumnInfos().length != this.colInfos_.length) {
            throw new IllegalStateException("ResultSet column count has changed");
        }
    }
}

