/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.jdbc.StarResultSet;

public class SequentialResultSetStarTable
extends AbstractStarTable {
    private final StarResultSet srset_;
    private boolean seqCreated_;

    public SequentialResultSetStarTable(ResultSet rset) throws SQLException {
        this(new StarResultSet(rset));
    }

    public SequentialResultSetStarTable(StarResultSet srset) {
        this.srset_ = srset;
    }

    public ResultSet getResultSet() {
        return this.srset_.getResultSet();
    }

    @Override
    public int getColumnCount() {
        return this.srset_.getColumnInfos().length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.srset_.getColumnInfos()[icol];
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    @Override
    public List getColumnAuxDataInfos() {
        return this.srset_.getColumnAuxDataInfos();
    }

    @Override
    public synchronized RowSequence getRowSequence() throws UnrepeatableSequenceException, IOException {
        if (this.seqCreated_) {
            throw new UnrepeatableSequenceException();
        }
        RowSequence rseq = this.srset_.createRowSequence();
        this.seqCreated_ = true;
        return rseq;
    }
}

