/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.jdbc.TypeMapper;
import uk.ac.starlink.table.jdbc.TypeMappers;
import uk.ac.starlink.table.jdbc.ValueHandler;

public class StarResultSet {
    private final ResultSet rset_;
    private final TypeMapper typeMapper_;
    private final ValueHandler[] valueHandlers_;
    private final ColumnInfo[] colInfos_;
    private final boolean isRandom_;
    private long nrow_ = -1L;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.jdbc");

    public StarResultSet(ResultSet rset) throws SQLException {
        this(rset, TypeMappers.STANDARD);
    }

    public StarResultSet(ResultSet rset, TypeMapper typeMapper) throws SQLException {
        this.rset_ = rset;
        this.typeMapper_ = typeMapper;
        ResultSetMetaData meta = rset.getMetaData();
        int ncol = meta.getColumnCount();
        this.valueHandlers_ = new ValueHandler[ncol];
        this.colInfos_ = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            this.valueHandlers_[icol] = typeMapper.createValueHandler(meta, icol + 1);
            this.colInfos_[icol] = this.valueHandlers_[icol].getColumnInfo();
        }
        switch (this.rset_.getType()) {
            case 1003: {
                this.isRandom_ = false;
                break;
            }
            case 1004: 
            case 1005: {
                this.isRandom_ = true;
                break;
            }
            default: {
                assert (false) : "Unknown ResultSet type";
                this.isRandom_ = false;
            }
        }
    }

    public ResultSet getResultSet() {
        return this.rset_;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.colInfos_;
    }

    public boolean isRandom() {
        return this.isRandom_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCount() {
        if (this.isRandom_) {
            if (this.nrow_ < 0L) {
                try {
                    StarResultSet starResultSet = this;
                    synchronized (starResultSet) {
                        this.rset_.afterLast();
                        this.rset_.previous();
                        this.nrow_ = this.rset_.getRow();
                    }
                }
                catch (SQLException e) {
                    logger_.warning("Failed to get table length: " + e);
                    this.nrow_ = 0L;
                }
            }
            return this.nrow_;
        }
        return -1L;
    }

    public List getColumnAuxDataInfos() {
        return this.typeMapper_.getColumnAuxDataInfos();
    }

    public void setRowIndex(long lrow) throws IOException {
        if (this.isRandom_) {
            try {
                this.rset_.absolute(Tables.checkedLongToInt(lrow) + 1);
            }
            catch (SQLException e) {
                throw (IOException)new IOException("Error setting to row " + lrow).initCause(e);
            }
        } else {
            throw new UnsupportedOperationException("No random access");
        }
    }

    public Object getCell(int icol) throws IOException {
        Object base;
        try {
            base = this.rset_.getObject(icol + 1);
        }
        catch (SQLException e) {
            throw (IOException)new IOException("SQL read error" + e).initCause(e);
        }
        return this.valueHandlers_[icol].getValue(base);
    }

    public Object[] getRow() throws IOException {
        int ncol = this.valueHandlers_.length;
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.getCell(icol);
        }
        return row;
    }

    public RowSequence createRowSequence() throws IOException {
        return new ResultSetRowSequence();
    }

    private class ResultSetRowSequence
    implements RowSequence {
        private ResultSetRowSequence() {
        }

        @Override
        public boolean next() throws IOException {
            try {
                return StarResultSet.this.rset_.next();
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        @Override
        public Object getCell(int icol) throws IOException {
            this.checkHasCurrentRow();
            return StarResultSet.this.getCell(icol);
        }

        @Override
        public Object[] getRow() throws IOException {
            this.checkHasCurrentRow();
            return StarResultSet.this.getRow();
        }

        @Override
        public void close() throws IOException {
            try {
                StarResultSet.this.rset_.close();
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        private void checkHasCurrentRow() {
            try {
                if (StarResultSet.this.rset_.isBeforeFirst()) {
                    throw new NoSuchElementException("No current row");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

