/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.HashSet;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.Cell;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.NdRange;

public abstract class AbstractCartesianMatchEngine
implements MatchEngine {
    private final int ndim_;
    private final double[] scales_;
    private final double[] rBinSizes_;
    private final DescribedValue binFactorParam_;
    private double binFactor_;
    private static final double DEFAULT_BIN_FACTOR = 8.0;
    private static final DefaultValueInfo BINFACT_INFO = new DefaultValueInfo("Bin Factor", Double.class, "Scaling factor to adjust bin size; larger values mean larger bins");

    public AbstractCartesianMatchEngine(int ndim) {
        this.ndim_ = ndim;
        this.scales_ = new double[this.ndim_];
        this.rBinSizes_ = new double[this.ndim_];
        this.binFactor_ = 8.0;
        this.binFactorParam_ = new BinFactorParameter();
    }

    public int getNdim() {
        return this.ndim_;
    }

    public void setBinFactor(double binFactor) {
        if (!(binFactor > 0.0)) {
            throw new IllegalArgumentException("Bin factor must be >0");
        }
        this.binFactor_ = binFactor;
        for (int id = 0; id < this.ndim_; ++id) {
            this.configureScale(id);
        }
    }

    public double getBinFactor() {
        return this.binFactor_;
    }

    public void setIsotropicScale(double scale) {
        for (int id = 0; id < this.ndim_; ++id) {
            this.setScale(id, scale);
        }
    }

    public double getIsotropicScale() {
        return this.scales_[0];
    }

    protected void setScale(int idim, double scale) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("Scale must be >0");
        }
        this.scales_[idim] = scale;
        this.configureScale(idim);
    }

    protected double getScale(int idim) {
        return this.scales_[idim];
    }

    private void configureScale(int idim) {
        this.rBinSizes_[idim] = 1.0 / (this.scales_[idim] * this.binFactor_);
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return new DescribedValue[]{this.binFactorParam_};
    }

    protected Object[] getRadiusBins(double[] coords, double radius) {
        return radius >= 0.0 ? this.doGetBins(coords, radius) : NO_BINS;
    }

    protected Object[] getScaleBins(double[] coords) {
        return this.doGetBins(coords, Double.NaN);
    }

    private Object[] doGetBins(double[] coords, double radius) {
        boolean useScale = Double.isNaN(radius);
        int[] llo = new int[this.ndim_];
        int[] lhi = new int[this.ndim_];
        int ncell = 1;
        for (int id = 0; id < this.ndim_; ++id) {
            double c0 = coords[id];
            if (Double.isNaN(c0)) {
                return NO_BINS;
            }
            double r = useScale ? this.scales_[id] : radius;
            llo[id] = this.getLabelComponent(id, c0 - r);
            lhi[id] = this.getLabelComponent(id, c0 + r);
            ncell *= lhi[id] - llo[id] + 1;
        }
        Object[] cells = new Cell[ncell];
        int[] label = (int[])llo.clone();
        block1: for (int ic = 0; ic < ncell; ++ic) {
            cells[ic] = new Cell((int[])label.clone());
            for (int jd = 0; jd < this.ndim_; ++jd) {
                int n = jd;
                label[n] = label[n] + 1;
                if (label[n] <= lhi[jd]) continue block1;
                label[jd] = llo[jd];
            }
        }
        assert (Arrays.equals(label, llo));
        assert (new HashSet<Object>(Arrays.asList(cells)).size() == cells.length);
        return cells;
    }

    private int getLabelComponent(int idim, double coord) {
        return (int)Math.floor(coord * this.rBinSizes_[idim]);
    }

    static double matchScore(int ndim, double[] coords1, double[] coords2, double err) {
        double err2 = err * err;
        double dist2 = 0.0;
        for (int id = 0; id < ndim; ++id) {
            double d = coords2[id] - coords1[id];
            if ((dist2 += d * d) <= err2) continue;
            return -1.0;
        }
        double score = Math.sqrt(dist2);
        assert (score >= 0.0 && score <= err);
        return score;
    }

    static NdRange createExtendedBounds(NdRange inRange, double err, int[] idims) {
        Comparable[] inMins = inRange.getMins();
        Comparable[] inMaxs = inRange.getMaxs();
        Comparable[] outMins = new Comparable[inMins.length];
        Comparable[] outMaxs = new Comparable[inMaxs.length];
        for (int jd = 0; jd < idims.length; ++jd) {
            int id = idims[jd];
            outMins[id] = AbstractCartesianMatchEngine.add(inMins[id], -err);
            outMaxs[id] = AbstractCartesianMatchEngine.add(inMaxs[id], err);
        }
        return new NdRange(outMins, outMaxs);
    }

    static int[] indexRange(int ibase, int icount) {
        int[] jxs = new int[icount];
        for (int i = 0; i < icount; ++i) {
            jxs[i] = ibase + i;
        }
        return jxs;
    }

    ValueInfo createCoordinateInfo(int idim) {
        DefaultValueInfo info = new DefaultValueInfo(this.getCoordinateName(idim), Number.class, this.getCoordinateDescription(idim));
        info.setNullable(false);
        return info;
    }

    String getCoordinateName(int idim) {
        return this.ndim_ <= 3 ? (new String[]{"X", "Y", "Z"})[idim] : "Co-ord #" + (idim + 1);
    }

    String getCoordinateDescription(int idim) {
        return "Cartesian co-ordinate #" + (idim + 1);
    }

    public abstract String toString();

    static double getNumberValue(Object numobj) {
        return numobj instanceof Number ? ((Number)numobj).doubleValue() : Double.NaN;
    }

    static Comparable add(Comparable in, double incr) {
        if (!(in instanceof Number) || Double.isNaN(incr)) {
            return null;
        }
        double dval = ((Number)((Object)in)).doubleValue() + incr;
        Class<?> clazz = in.getClass();
        if (incr < 0.0) {
            if (clazz == Byte.class && Math.floor(dval) >= -128.0) {
                return new Byte((byte)Math.floor(dval));
            }
            if (clazz == Short.class && Math.floor(dval) >= -32768.0) {
                return new Short((short)Math.floor(dval));
            }
            if (clazz == Integer.class && Math.floor(dval) >= -2.147483648E9) {
                return new Integer((int)Math.floor(dval));
            }
            if (clazz == Long.class && Math.floor(dval) >= -9.223372036854776E18) {
                return new Long((long)Math.floor(dval));
            }
            if (clazz == Float.class) {
                return new Float((float)dval);
            }
            if (clazz == Double.class) {
                return new Double(dval);
            }
            return null;
        }
        if (incr > 0.0) {
            if (clazz == Byte.class && Math.ceil(dval) <= 127.0) {
                return new Byte((byte)Math.ceil(dval));
            }
            if (clazz == Short.class && Math.ceil(dval) <= 32767.0) {
                return new Short((short)Math.ceil(dval));
            }
            if (clazz == Integer.class && Math.ceil(dval) <= 2.147483647E9) {
                return new Integer((int)Math.ceil(dval));
            }
            if (clazz == Long.class && Math.ceil(dval) <= 9.223372036854776E18) {
                return new Long((long)Math.ceil(dval));
            }
            if (clazz == Float.class) {
                return new Float((float)dval);
            }
            if (clazz == Double.class) {
                return new Double(dval);
            }
            return null;
        }
        assert (incr == 0.0);
        return in instanceof Comparable ? in : null;
    }

    class IsotropicScaleParameter
    extends DescribedValue {
        public IsotropicScaleParameter(ValueInfo info) {
            super(info);
        }

        @Override
        public Object getValue() {
            return new Double(AbstractCartesianMatchEngine.this.getIsotropicScale());
        }

        @Override
        public void setValue(Object value) {
            AbstractCartesianMatchEngine.this.setIsotropicScale(((Number)value).doubleValue());
        }
    }

    class BinFactorParameter
    extends DescribedValue {
        BinFactorParameter() {
            super(BINFACT_INFO);
        }

        @Override
        public Object getValue() {
            return new Double(AbstractCartesianMatchEngine.this.getBinFactor());
        }

        @Override
        public void setValue(Object value) {
            AbstractCartesianMatchEngine.this.setBinFactor(((Number)value).doubleValue());
        }
    }
}

