/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.SkyPixellator;

public abstract class AbstractSkyMatchEngine
implements MatchEngine {
    private final SkyPixellator pixellator_;
    static final double INVERSE_ARC_SECOND = 206264.80624709636;

    protected AbstractSkyMatchEngine(SkyPixellator pixellator, double scale) {
        this.pixellator_ = pixellator;
        this.setScale(scale);
    }

    protected void setScale(double scale) {
        this.pixellator_.setScale(scale);
    }

    protected double getScale() {
        return this.pixellator_.getScale();
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        return new DescribedValue[]{this.pixellator_.getTuningParameter()};
    }

    static double matchScore(double alpha1, double delta1, double alpha2, double delta2, double maxerr) {
        if (Math.abs(delta1 - delta2) > maxerr) {
            return -1.0;
        }
        double sep = AbstractSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2, delta2);
        return sep <= maxerr ? sep * 206264.80624709636 : -1.0;
    }

    static double maxScore(double maxerr) {
        return 206264.80624709636 * maxerr;
    }

    Object[] getBins(double alpha, double delta, double radius) {
        return !Double.isNaN(alpha) && !Double.isNaN(delta) && radius >= 0.0 ? this.pixellator_.getPixels(alpha, delta, radius) : NO_BINS;
    }

    public abstract String toString();

    public static double calculateSeparation(double alpha1, double delta1, double alpha2, double delta2) {
        return AbstractSkyMatchEngine.haversineSeparationFormula(alpha1, delta1, alpha2, delta2);
    }

    private static double cosineSeparationFormula(double alpha1, double delta1, double alpha2, double delta2) {
        return Math.acos(Math.sin(delta1) * Math.sin(delta2) + Math.cos(delta1) * Math.cos(delta2) * Math.cos(alpha1 - alpha2));
    }

    private static double haversineSeparationFormula(double alpha1, double delta1, double alpha2, double delta2) {
        double sa2;
        double sd2 = Math.sin(0.5 * (delta2 - delta1));
        double a = sd2 * sd2 + (sa2 = Math.sin(0.5 * (alpha2 - alpha1))) * sa2 * Math.cos(delta1) * Math.cos(delta2);
        return a < 1.0 ? 2.0 * Math.asin(Math.sqrt(a)) : Math.PI;
    }

    static NdRange createExtendedSkyBounds(NdRange inRange, int ialpha, int idelta, double err) {
        double alphaMaxOut;
        double alphaMinOut;
        Comparable[] minTuple = inRange.getMins();
        Comparable[] maxTuple = inRange.getMaxs();
        double alphaMinIn = AbstractSkyMatchEngine.getNumberValue(minTuple[ialpha]);
        double deltaMinIn = AbstractSkyMatchEngine.getNumberValue(minTuple[idelta]);
        double alphaMaxIn = AbstractSkyMatchEngine.getNumberValue(maxTuple[ialpha]);
        double deltaMaxIn = AbstractSkyMatchEngine.getNumberValue(maxTuple[idelta]);
        double deltaMinOut = deltaMinIn - err;
        double deltaMaxOut = deltaMaxIn + err;
        if (!Double.isNaN(deltaMinOut) && !Double.isNaN(deltaMaxOut)) {
            double alphaDiffMax = Math.max(Math.abs(err / Math.cos(deltaMinOut)), Math.abs(err / Math.cos(deltaMaxOut)));
            alphaMinOut = alphaMinIn - alphaDiffMax;
            alphaMaxOut = alphaMaxIn + alphaDiffMax;
            if (!(alphaMinOut >= 0.0 && alphaMinOut <= Math.PI * 2 && alphaMaxOut >= 0.0 && alphaMaxOut <= Math.PI * 2)) {
                alphaMinOut = Double.NaN;
                alphaMaxOut = Double.NaN;
            }
        } else {
            alphaMinOut = Double.NaN;
            alphaMaxOut = Double.NaN;
        }
        Comparable[] minOuts = new Comparable[minTuple.length];
        Comparable[] maxOuts = new Comparable[maxTuple.length];
        minOuts[ialpha] = AbstractSkyMatchEngine.toFloatingNumber(alphaMinOut, minTuple[ialpha]);
        minOuts[idelta] = AbstractSkyMatchEngine.toFloatingNumber(deltaMinOut, minTuple[idelta]);
        maxOuts[ialpha] = AbstractSkyMatchEngine.toFloatingNumber(alphaMaxOut, maxTuple[ialpha]);
        maxOuts[idelta] = AbstractSkyMatchEngine.toFloatingNumber(deltaMaxOut, maxTuple[idelta]);
        return new NdRange(minOuts, maxOuts);
    }

    static double getNumberValue(Object numobj) {
        return numobj instanceof Number ? ((Number)numobj).doubleValue() : Double.NaN;
    }

    private static Comparable toFloatingNumber(double value, Comparable template) {
        if (Double.isNaN(value)) {
            return null;
        }
        if (template instanceof Double) {
            return new Double(value);
        }
        if (template instanceof Float) {
            return new Float((float)value);
        }
        return null;
    }

    class SkyScaleParameter
    extends DescribedValue {
        SkyScaleParameter(ValueInfo info) {
            super(info);
        }

        @Override
        public Object getValue() {
            return new Double(AbstractSkyMatchEngine.this.getScale());
        }

        @Override
        public void setValue(Object value) {
            AbstractSkyMatchEngine.this.setScale(AbstractSkyMatchEngine.getNumberValue(value));
        }
    }
}

