/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class AnisotropicCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final double[] err2rs_;
    private final DescribedValue[] matchParams_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Normalised distance between matched points (0 is identical, 1 is worst possible match)");

    public AnisotropicCartesianMatchEngine(double[] errs) {
        super(errs.length);
        this.ndim_ = errs.length;
        this.err2rs_ = new double[this.ndim_];
        this.matchParams_ = new DescribedValue[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            this.matchParams_[id] = new ErrorParameter(id);
            this.setScale(id, errs[id]);
        }
    }

    public void setError(int idim, double err) {
        this.setScale(idim, err);
    }

    public double getError(int idim) {
        return this.getScale(idim);
    }

    @Override
    protected void setScale(int idim, double err) {
        super.setScale(idim, err);
        this.err2rs_[idim] = 1.0 / (err * err);
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double[] coords1 = this.toCoords(tuple1);
        double[] coords2 = this.toCoords(tuple2);
        double normDist2 = 0.0;
        for (int id = 0; id < this.ndim_; ++id) {
            double d = coords2[id] - coords1[id];
            if ((normDist2 += d * d * this.err2rs_[id]) <= 1.0) continue;
            return -1.0;
        }
        assert (normDist2 >= 0.0 && normDist2 <= 1.0);
        return Math.sqrt(normDist2);
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getScaleBins(this.toCoords(tuple));
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        NdRange inRange = inRanges[index];
        Comparable[] inMins = inRange.getMins();
        Comparable[] inMaxs = inRange.getMaxs();
        Comparable[] outMins = new Comparable[this.ndim_];
        Comparable[] outMaxs = new Comparable[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            double err = this.getError(id);
            outMins[id] = AnisotropicCartesianMatchEngine.add(inMins[id], -err);
            outMaxs[id] = AnisotropicCartesianMatchEngine.add(inMaxs[id], err);
        }
        return new NdRange(outMins, outMaxs);
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cartesian Anisotropic";
    }

    private double[] toCoords(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            coords[id] = AnisotropicCartesianMatchEngine.getNumberValue(tuple[id]);
        }
        return coords;
    }

    private class ErrorParameter
    extends DescribedValue {
        private final int idim_;

        ErrorParameter(int idim) {
            super(new DefaultValueInfo("Error in " + AnisotropicCartesianMatchEngine.this.getCoordinateName(idim), Number.class, "Axis length of error ellipse in " + AnisotropicCartesianMatchEngine.this.getCoordinateDescription(idim) + " direction"));
            this.idim_ = idim;
        }

        @Override
        public Object getValue() {
            return new Double(AnisotropicCartesianMatchEngine.this.getError(this.idim_));
        }

        @Override
        public void setValue(Object value) {
            AnisotropicCartesianMatchEngine.this.setError(this.idim_, AbstractCartesianMatchEngine.getNumberValue(value));
        }
    }
}

