/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.LongList;

class Binners {
    private Binners() {
    }

    public static ObjectBinner createObjectBinner() {
        return new CombinationObjectBinner();
    }

    public static ObjectBinner createModifiableObjectBinner() {
        return new StorageListObjectBinner();
    }

    public static LongBinner createLongBinner(long nrow) {
        return nrow >= 0L && nrow < Integer.MAX_VALUE ? new CombinationIntLongBinner() : new LongListLongBinner();
    }

    private static class StorageList
    extends LinkedList {
        private StorageList() {
        }
    }

    private static class CombinationIntLongBinner
    extends MapLongBinner {
        private static int MAX_ARRAY_SIZE = 32;
        private Integer lastInt_ = new Integer(-1);
        private int[] lastInts_ = new int[0];

        private CombinationIntLongBinner() {
        }

        @Override
        protected Object addToListable(Object listable, long ltem) {
            int item = Tables.checkedLongToInt(ltem);
            if (listable == null) {
                if (this.lastInt_ != item) {
                    this.lastInt_ = new Integer(item);
                }
                return this.lastInt_;
            }
            if (listable instanceof Integer) {
                int[] nArray;
                int i1 = (Integer)listable;
                int i2 = item;
                if (this.lastInts_.length == 2 && this.lastInts_[0] == i1 && this.lastInts_[1] == i2) {
                    nArray = this.lastInts_;
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = i1;
                    nArray = nArray2;
                    nArray2[1] = i2;
                }
                return nArray;
            }
            if (listable instanceof int[]) {
                int[] oldItems = (int[])listable;
                int nItem = oldItems.length;
                if (nItem < MAX_ARRAY_SIZE) {
                    int[] newItems = new int[nItem + 1];
                    System.arraycopy(oldItems, 0, newItems, 0, nItem);
                    newItems[nItem] = item;
                    return Arrays.equals(newItems, this.lastInts_) ? this.lastInts_ : newItems;
                }
                assert (nItem == MAX_ARRAY_SIZE);
                IntList list = new IntList(oldItems){

                    @Override
                    protected int nextCapacity(int currentCapacity) {
                        return currentCapacity * 5 / 4 + 1;
                    }
                };
                list.add(item);
                return list;
            }
            if (listable instanceof IntList) {
                IntList list = (IntList)listable;
                list.add(item);
                return list;
            }
            assert (false);
            return null;
        }

        @Override
        protected long[] getLongsFromListable(Object listable) {
            if (listable == null) {
                return null;
            }
            if (listable instanceof Integer) {
                return new long[]{((Integer)listable).intValue()};
            }
            if (listable instanceof int[]) {
                int[] items = (int[])listable;
                long[] ltems = new long[items.length];
                for (int i = 0; i < items.length; ++i) {
                    ltems[i] = items[i];
                }
                return ltems;
            }
            if (listable instanceof IntList) {
                IntList list = (IntList)listable;
                int nItem = list.size();
                long[] ltems = new long[nItem];
                for (int i = 0; i < nItem; ++i) {
                    ltems[i] = list.get(i);
                }
                return ltems;
            }
            assert (false);
            return null;
        }
    }

    private static class LongListLongBinner
    extends MapLongBinner {
        private LongListLongBinner() {
        }

        @Override
        protected Object addToListable(Object listable, long item) {
            if (listable == null) {
                LongList list = new LongList(1);
                list.add(item);
                return list;
            }
            LongList list = (LongList)listable;
            list.add(item);
            return list;
        }

        @Override
        protected long[] getLongsFromListable(Object listable) {
            if (listable == null) {
                return null;
            }
            return ((LongList)listable).toLongArray();
        }
    }

    private static abstract class MapLongBinner
    implements LongBinner {
        private final Map map_ = new HashMap();

        private MapLongBinner() {
        }

        @Override
        public void addItem(Object key, long item) {
            this.map_.put(key, this.addToListable(this.map_.get(key), item));
        }

        @Override
        public long[] getLongs(Object key) {
            return this.getLongsFromListable(this.map_.get(key));
        }

        @Override
        public Iterator getKeyIterator() {
            return this.map_.keySet().iterator();
        }

        @Override
        public long getBinCount() {
            return this.map_.size();
        }

        protected abstract Object addToListable(Object var1, long var2);

        protected abstract long[] getLongsFromListable(Object var1);
    }

    private static class CombinationObjectBinner
    extends MapObjectBinner {
        private CombinationObjectBinner() {
        }

        @Override
        protected Object addToListable(Object listable, Object item) {
            if (item instanceof StorageList) {
                throw new IllegalArgumentException("Can't mix keys with values");
            }
            if (listable == null) {
                return item;
            }
            if (listable instanceof StorageList) {
                ((List)listable).add(item);
                return listable;
            }
            StorageList list = new StorageList();
            list.add(listable);
            list.add(item);
            return list;
        }

        @Override
        protected List getListFromListable(Object listable) {
            if (listable == null) {
                return null;
            }
            if (listable instanceof StorageList) {
                return (List)listable;
            }
            return Collections.singletonList(listable);
        }
    }

    private static class StorageListObjectBinner
    extends MapObjectBinner {
        private StorageListObjectBinner() {
        }

        @Override
        protected Object addToListable(Object listable, Object item) {
            List<Object> list = listable == null ? new StorageList() : (List)listable;
            list.add(item);
            return list;
        }

        @Override
        protected List getListFromListable(Object listable) {
            return (List)listable;
        }
    }

    private static abstract class MapObjectBinner
    implements ObjectBinner {
        private final Map map_ = new HashMap();
        private long nItem_;

        private MapObjectBinner() {
        }

        @Override
        public void addItem(Object key, Object item) {
            ++this.nItem_;
            this.map_.put(key, this.addToListable(this.map_.get(key), item));
        }

        @Override
        public List getList(Object key) {
            return this.getListFromListable(this.map_.get(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map_.containsKey(key);
        }

        @Override
        public void remove(Object key) {
            this.map_.remove(key);
        }

        @Override
        public Iterator getKeyIterator() {
            return this.map_.keySet().iterator();
        }

        @Override
        public long getItemCount() {
            return this.nItem_;
        }

        @Override
        public long getBinCount() {
            return this.map_.size();
        }

        protected abstract Object addToListable(Object var1, Object var2);

        protected abstract List getListFromListable(Object var1);
    }
}

