/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class CombinedMatchEngine
implements MatchEngine {
    private final boolean inSphere;
    private final MatchEngine[] engines;
    private final int[] tupleSizes;
    private final int[] tupleStarts;
    private final int nPart;
    private String name;
    private final Object[][] work0;
    private final Object[][] work1;
    private final Object[][] work2;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between points in combined space");

    public CombinedMatchEngine(MatchEngine[] engines) {
        this.inSphere = false;
        this.engines = engines;
        this.nPart = engines.length;
        this.tupleSizes = new int[this.nPart];
        for (int i = 0; i < this.nPart; ++i) {
            this.tupleSizes[i] = engines[i].getTupleInfos().length;
        }
        this.tupleStarts = new int[this.nPart];
        int ts = 0;
        this.work0 = new Object[this.nPart][];
        this.work1 = new Object[this.nPart][];
        this.work2 = new Object[this.nPart][];
        for (int i = 0; i < this.nPart; ++i) {
            this.tupleStarts[i] = ts;
            ts += this.tupleSizes[i];
            this.work0[i] = new Object[this.tupleSizes[i]];
            this.work1[i] = new Object[this.tupleSizes[i]];
            this.work2[i] = new Object[this.tupleSizes[i]];
        }
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < this.nPart; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(engines[i].toString());
        }
        buf.append(")");
        this.name = buf.toString();
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double sum2 = 0.0;
        for (int i = 0; i < this.nPart; ++i) {
            Object[] subTuple1 = this.work1[i];
            Object[] subTuple2 = this.work2[i];
            System.arraycopy(tuple1, this.tupleStarts[i], subTuple1, 0, this.tupleSizes[i]);
            System.arraycopy(tuple2, this.tupleStarts[i], subTuple2, 0, this.tupleSizes[i]);
            MatchEngine engine = this.engines[i];
            double score = engine.matchScore(subTuple1, subTuple2);
            if (score < 0.0) {
                return -1.0;
            }
            double scale = engine.getScoreScale();
            double d1 = scale > 0.0 ? score / scale : score;
            sum2 += d1 * d1;
        }
        double sum1 = Math.sqrt(sum2);
        if (this.inSphere) {
            return sum1 <= 1.0 ? sum1 : -1.0;
        }
        return sum1;
    }

    @Override
    public double getScoreScale() {
        for (int i = 0; i < this.nPart; ++i) {
            if (this.engines[i].getScoreScale() > 0.0) continue;
            return Double.NaN;
        }
        return Math.sqrt(this.nPart);
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        Object[][] binBag = new Object[this.nPart][];
        for (int i = 0; i < this.nPart; ++i) {
            Object[] subTuple = this.work0[i];
            System.arraycopy(tuple, this.tupleStarts[i], subTuple, 0, this.tupleSizes[i]);
            binBag[i] = this.engines[i].getBins(subTuple);
        }
        int nBin = 1;
        for (int i = 0; i < this.nPart; ++i) {
            nBin *= binBag[i].length;
        }
        Object[] bins = new Object[nBin];
        int[] offset = new int[this.nPart];
        block2: for (int ibin = 0; ibin < nBin; ++ibin) {
            ArrayList<Object> bin = new ArrayList<Object>(this.nPart);
            for (int i = 0; i < this.nPart; ++i) {
                bin.add(binBag[i][offset[i]]);
            }
            bins[ibin] = bin;
            for (int j = 0; j < this.nPart; ++j) {
                int n = j;
                offset[n] = offset[n] + 1;
                if (offset[n] < binBag[j].length) continue block2;
                offset[j] = 0;
            }
        }
        for (int i = 0; i < this.nPart; ++i) {
            assert (offset[i] == 0);
        }
        return bins;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        int nargs = this.tupleStarts[this.nPart - 1] + this.tupleSizes[this.nPart - 1];
        ValueInfo[] infos = new ValueInfo[nargs];
        for (int i = 0; i < this.nPart; ++i) {
            System.arraycopy(this.engines[i].getTupleInfos(), 0, infos, this.tupleStarts[i], this.tupleSizes[i]);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        for (int i = 0; i < this.nPart; ++i) {
            params.addAll(Arrays.asList(this.engines[i].getMatchParameters()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    @Override
    public DescribedValue[] getTuningParameters() {
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        for (int i = 0; i < this.nPart; ++i) {
            params.addAll(Arrays.asList(this.engines[i].getTuningParameters()));
        }
        return params.toArray(new DescribedValue[0]);
    }

    @Override
    public boolean canBoundMatch() {
        for (int i = 0; i < this.nPart; ++i) {
            if (!this.engines[i].canBoundMatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        int nr = inRanges.length;
        Comparable[] outMins = (Comparable[])inRanges[index].getMins().clone();
        Comparable[] outMaxs = (Comparable[])inRanges[index].getMaxs().clone();
        for (int ip = 0; ip < this.nPart; ++ip) {
            MatchEngine engine = this.engines[ip];
            if (!engine.canBoundMatch()) continue;
            int size = this.tupleSizes[ip];
            int start = this.tupleStarts[ip];
            NdRange[] subInRanges = new NdRange[nr];
            for (int ir = 0; ir < nr; ++ir) {
                Comparable[] subInMins = new Comparable[size];
                Comparable[] subInMaxs = new Comparable[size];
                System.arraycopy(inRanges[ir].getMins(), start, subInMins, 0, size);
                System.arraycopy(inRanges[ir].getMaxs(), start, subInMaxs, 0, size);
                subInRanges[ir] = new NdRange(subInMins, subInMaxs);
            }
            NdRange subOutRange = engine.getMatchBounds(subInRanges, index);
            System.arraycopy(subOutRange.getMins(), 0, outMins, start, size);
            System.arraycopy(subOutRange.getMaxs(), 0, outMaxs, start, size);
        }
        return new NdRange(outMins, outMaxs);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

