/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class CuboidCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final double[] err2s_;
    private final DescribedValue[] matchParams_;
    private double scoreScale_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Unscaled distance between matched points");

    public CuboidCartesianMatchEngine(double[] errs) {
        super(errs.length);
        this.ndim_ = errs.length;
        this.err2s_ = new double[this.ndim_];
        this.matchParams_ = new DescribedValue[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            this.matchParams_[id] = new ErrorParameter(id);
            this.setScale(id, errs[id]);
        }
    }

    public void setError(int idim, double err) {
        this.setScale(idim, err);
    }

    public double getError(int idim) {
        return this.getScale(idim);
    }

    @Override
    protected void setScale(int idim, double err) {
        super.setScale(idim, err);
        this.err2s_[idim] = err * err;
        double sscale2 = 0.0;
        for (int i = 0; i < this.ndim_; ++i) {
            sscale2 += this.err2s_[i];
        }
        this.scoreScale_ = Math.sqrt(sscale2);
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double[] coords1 = this.toCoords(tuple1);
        double[] coords2 = this.toCoords(tuple2);
        double dist2 = 0.0;
        for (int id = 0; id < this.ndim_; ++id) {
            double d = coords2[id] - coords1[id];
            double d2 = d * d;
            if (d2 > this.err2s_[id]) {
                return -1.0;
            }
            dist2 += d2;
        }
        return Math.sqrt(dist2);
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getScaleBins(this.toCoords(tuple));
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public double getScoreScale() {
        return this.scoreScale_;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        Comparable[] inMins = inRanges[index].getMins();
        Comparable[] inMaxs = inRanges[index].getMaxs();
        Comparable[] outMins = new Comparable[this.ndim_];
        Comparable[] outMaxs = new Comparable[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            double err = this.getError(id);
            outMins[id] = CuboidCartesianMatchEngine.add(inMins[id], -err);
            outMaxs[id] = CuboidCartesianMatchEngine.add(inMaxs[id], err);
        }
        return new NdRange(outMins, outMaxs);
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cuboid";
    }

    private double[] toCoords(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            coords[id] = CuboidCartesianMatchEngine.getNumberValue(tuple[id]);
        }
        return coords;
    }

    private class ErrorParameter
    extends DescribedValue {
        private final int idim_;

        ErrorParameter(int idim) {
            super(new DefaultValueInfo("Error in " + CuboidCartesianMatchEngine.this.getCoordinateName(idim), Number.class, "Half length of cuboid in " + CuboidCartesianMatchEngine.this.getCoordinateDescription(idim) + " direction"));
            this.idim_ = idim;
        }

        @Override
        public Object getValue() {
            return new Double(CuboidCartesianMatchEngine.this.getError(this.idim_));
        }

        @Override
        public void setValue(Object value) {
            CuboidCartesianMatchEngine.this.setError(this.idim_, AbstractCartesianMatchEngine.getNumberValue(value));
        }
    }
}

