/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.AngleOptimiser;
import uk.ac.starlink.table.join.NdRange;

public class EllipseCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERRSCALE_INFO)};
    private boolean recogniseCircles_;
    private static final double NaN = Double.NaN;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Normalised distance between ellipses in range 0-2; 0 is concentric, 1 is centre-on-edge, 2 is edges touching");
    private static final DefaultValueInfo ERRSCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of per-object error distance; just used for tuning in conjunction with bin factor");
    private static final DefaultValueInfo X_INFO = new DefaultValueInfo("X", Number.class, "X coordinate of centre");
    private static final DefaultValueInfo Y_INFO = new DefaultValueInfo("Y", Number.class, "Y coordinate of centre");
    private static final DefaultValueInfo A_INFO = new DefaultValueInfo("Primary Radius", Number.class, "Length of ellipse semi-major axis");
    private static final DefaultValueInfo B_INFO = new DefaultValueInfo("Secondary Radius", Number.class, "Length of ellipse semi-minor axis");
    private static final DefaultValueInfo THETA_INFO = new DefaultValueInfo("Orientation Angle", Number.class, "Angle from X axis towards Y axis of semi-major axis");
    private static final Logger logger_;

    public EllipseCartesianMatchEngine(double scale) {
        super(2);
        this.setIsotropicScale(scale);
        this.setRecogniseCircles(true);
    }

    public void setScale(double scale) {
        super.setIsotropicScale(scale);
    }

    public double getScale() {
        return super.getIsotropicScale();
    }

    public void setRecogniseCircles(boolean recogniseCircles) {
        this.recogniseCircles_ = recogniseCircles;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{X_INFO, Y_INFO, A_INFO, B_INFO, THETA_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public String toString() {
        return "2-d Cartesian Ellipses";
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        Match match = EllipseCartesianMatchEngine.getMatch(EllipseCartesianMatchEngine.toEllipse(tuple1), EllipseCartesianMatchEngine.toEllipse(tuple2), this.recogniseCircles_);
        return match == null ? -1.0 : match.score_;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        Ellipse ellipse = EllipseCartesianMatchEngine.toEllipse(tuple);
        return this.getRadiusBins(new double[]{ellipse.x_, ellipse.y_}, ellipse.getMaxRadius());
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        double maxRadius = 0.0;
        for (NdRange inRange : inRanges) {
            Comparable[] maxs = inRange.getMaxs();
            double maxA = EllipseCartesianMatchEngine.getNumberValue(maxs[2]);
            double maxB = EllipseCartesianMatchEngine.getNumberValue(maxs[3]);
            maxRadius = Math.max(maxRadius, Math.max(maxA, maxB));
        }
        return EllipseCartesianMatchEngine.createExtendedBounds(inRanges[index], 2.0 * maxRadius, EllipseCartesianMatchEngine.indexRange(0, 2));
    }

    private static Ellipse toEllipse(Object[] tuple) {
        double x = ((Number)tuple[0]).doubleValue();
        double y = ((Number)tuple[1]).doubleValue();
        if (tuple[2] instanceof Number && tuple[3] instanceof Number && tuple[4] instanceof Number) {
            double a = ((Number)tuple[2]).doubleValue();
            double b = ((Number)tuple[3]).doubleValue();
            double theta = ((Number)tuple[4]).doubleValue();
            return new Ellipse(x, y, a, b, theta);
        }
        return new Ellipse(x, y);
    }

    static Match getMatch(Ellipse e1, Ellipse e2, boolean recogniseCircles) {
        boolean isCenterInside2;
        double x1 = e1.x_;
        double y1 = e1.y_;
        double x2 = e2.x_;
        double y2 = e2.y_;
        if (EllipseCartesianMatchEngine.sq(x2 - x1) + EllipseCartesianMatchEngine.sq(y2 - y1) > EllipseCartesianMatchEngine.sq(e1.getMaxRadius() + e2.getMaxRadius())) {
            return null;
        }
        boolean isPoint1 = e1.isPoint();
        boolean isPoint2 = e2.isPoint();
        if (isPoint1 && isPoint2) {
            return x1 == x2 && y1 == y2 ? new Match(0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN) : null;
        }
        if (isPoint1) {
            double s = EllipseCartesianMatchEngine.scaledDistance(e2, x1, y1);
            return s <= 1.0 ? new Match(s, Double.NaN, Double.NaN, x1, y1) : null;
        }
        if (isPoint2) {
            double s = EllipseCartesianMatchEngine.scaledDistance(e1, x2, y2);
            return s <= 1.0 ? new Match(s, x2, x2, Double.NaN, Double.NaN) : null;
        }
        double sc1 = EllipseCartesianMatchEngine.scaledDistance(e1, x2, y2);
        double sc2 = EllipseCartesianMatchEngine.scaledDistance(e2, x1, y1);
        boolean isCenterInside1 = sc1 <= 1.0;
        boolean bl = isCenterInside2 = sc2 <= 1.0;
        if (isCenterInside1 && isCenterInside2) {
            return sc1 < sc2 ? new Match(sc1, x2, y2, Double.NaN, Double.NaN) : new Match(sc2, Double.NaN, Double.NaN, x1, y1);
        }
        if (isCenterInside1) {
            return new Match(sc1, x2, y2, Double.NaN, Double.NaN);
        }
        if (isCenterInside2) {
            return new Match(sc2, Double.NaN, Double.NaN, x1, y1);
        }
        if (e1.isCircle() && e2.isCircle() && recogniseCircles) {
            double r1 = e1.a_;
            double r2 = e2.a_;
            assert (r1 == e1.b_);
            assert (r2 == e2.b_);
            double dx = x2 - x1;
            double dy = y2 - y1;
            double s = Math.sqrt(dx * dx + dy * dy);
            if (s > r1 + r2) {
                return null;
            }
            double fx = dx / s;
            double fy = dy / s;
            return new Match(1.0 + 0.5 * ((s - r2) / r1 + (s - r1) / r2), x2 - r2 * fx, y2 - r2 * fy, x1 + r1 * fx, y1 + r1 * fy);
        }
        double[] p1 = EllipseCartesianMatchEngine.findClosestEdgePoint(e1, e2);
        double sp1 = EllipseCartesianMatchEngine.scaledDistance(e1, p1[0], p1[1]);
        if (sp1 > 1.0) {
            return null;
        }
        double[] p2 = EllipseCartesianMatchEngine.findClosestEdgePoint(e2, e1);
        double sp2 = EllipseCartesianMatchEngine.scaledDistance(e2, p2[0], p2[1]);
        assert (sp2 <= 1.0);
        return new Match(1.0 + 0.5 * (sp1 + sp2), p1[0], p1[1], p2[0], p2[1]);
    }

    static double scaledDistance(Ellipse e, double x, double y) {
        double rx = x - e.x_;
        double ry = y - e.y_;
        double c = Math.cos(e.theta_);
        double s = Math.sin(e.theta_);
        double dx = (rx * c - ry * s) / e.a_;
        double dy = (rx * s + ry * c) / e.b_;
        return Math.sqrt(dx * dx + dy * dy);
    }

    static double[] edgePoint(Ellipse e, double phi) {
        double cp = Math.cos(phi);
        double sp = Math.sin(phi);
        double ct = Math.cos(e.theta_);
        double st = Math.sin(e.theta_);
        double px = e.x_ + e.a_ * ct * cp + e.b_ * st * sp;
        double py = e.y_ + e.b_ * ct * sp - e.a_ * st * cp;
        return new double[]{px, py};
    }

    static double[] findClosestEdgePoint(final Ellipse e1, final Ellipse e2) {
        AngleOptimiser opt = new AngleOptimiser(1.0E-8, 40, 4){

            @Override
            public double[] calcDerivs(double phi) {
                return EllipseCartesianMatchEngine.calcSeparationDerivs(e1, e2, phi);
            }
        };
        double phi0 = EllipseCartesianMatchEngine.phiTowardsPoint(e2, e1.x_, e1.y_);
        double optPhi = opt.findExtremum(phi0, Boolean.TRUE);
        if (Double.isNaN(optPhi)) {
            if (Math.abs(EllipseCartesianMatchEngine.scaledDistance(e1, e2.x_, e2.y_) - 1.0) < 0.001) {
                return new double[]{e2.x_, e2.y_};
            }
            logger_.warning("Ellipse optimisation failed for " + e1 + ", " + e2);
            return EllipseCartesianMatchEngine.edgePoint(e2, phi0);
        }
        return EllipseCartesianMatchEngine.edgePoint(e2, optPhi);
    }

    static double phiTowardsPoint(Ellipse e, double x, double y) {
        double psi = Math.atan2(x - e.x_, y - e.y_);
        double phi = Math.atan2(e.a_ * Math.cos(psi - e.theta_), e.b_ * Math.sin(psi - e.theta_));
        assert (EllipseCartesianMatchEngine.isCollinear(new double[]{e.x_, e.y_}, EllipseCartesianMatchEngine.edgePoint(e, phi), new double[]{x, y}));
        return phi;
    }

    private static double[] calcSeparationDerivs(Ellipse e1, Ellipse e2, double phi2) {
        double a1 = e1.a_;
        double b1 = e1.b_;
        double x1 = e1.x_;
        double y1 = e1.y_;
        double c1 = Math.cos(e1.theta_);
        double s1 = Math.sin(e1.theta_);
        double a2 = e2.a_;
        double b2 = e2.b_;
        double x2 = e2.x_;
        double y2 = e2.y_;
        double c2 = Math.cos(e2.theta_);
        double s2 = Math.sin(e2.theta_);
        double x12 = x2 - x1;
        double y12 = y2 - y1;
        double c12 = Math.cos(e2.theta_ - e1.theta_);
        double s12 = Math.sin(e2.theta_ - e1.theta_);
        double raa1 = 1.0 / (a1 * a1);
        double rbb1 = 1.0 / (b1 * b1);
        double cp = Math.cos(phi2);
        double sp = Math.sin(phi2);
        double tcc = a2 * a2 * (c12 * c12 * raa1 + s12 * s12 * rbb1);
        double tss = b2 * b2 * (s12 * s12 * raa1 + c12 * c12 * rbb1);
        double tcs = 2.0 * a2 * b2 * c12 * s12 * (raa1 - rbb1);
        double tc = 2.0 * a2 * (c12 * raa1 * (x12 * c1 - y12 * s1) - s12 * rbb1 * (x12 * s1 + y12 * c1));
        double ts = 2.0 * b2 * (s12 * raa1 * (x12 * c1 - y12 * s1) + c12 * rbb1 * (x12 * s1 + y12 * c1));
        double t = raa1 * EllipseCartesianMatchEngine.sq(x12 * c1 - y12 * s1) + rbb1 * EllipseCartesianMatchEngine.sq(x12 * s1 + y12 * c1);
        double c2p = Math.cos(2.0 * phi2);
        double s2p = Math.sin(2.0 * phi2);
        return new double[]{tcc * cp * cp + tss * sp * sp + tcs * cp * sp + tc * cp + ts * sp + t, (tss - tcc) * s2p + tcs * c2p - tc * sp + ts * cp, 2.0 * (tss - tcc) * c2p - 2.0 * tcs * s2p - tc * cp - ts * sp};
    }

    private static double sq(double x) {
        return x * x;
    }

    private static boolean isCollinear(double[] r1, double[] r2, double[] r3) {
        double xa = r3[0] - r2[0];
        double yb = r2[1] - r1[1];
        double ya = r3[1] - r2[1];
        double xb = r2[0] - r1[0];
        double crossprod = xa * yb - ya * xb;
        return Math.abs(crossprod) < 1.0E-10;
    }

    static {
        A_INFO.setUCD("phys.size.smajAxis");
        B_INFO.setUCD("phys.size.sminAxis");
        THETA_INFO.setUnitString("radians");
        THETA_INFO.setUCD("pos.posAng");
        logger_ = Logger.getLogger("uk.ac.starlink.table.join");
    }

    static class Ellipse {
        final double x_;
        final double y_;
        final double a_;
        final double b_;
        final double theta_;

        Ellipse(double x, double y, double a, double b, double theta) {
            this.x_ = x;
            this.y_ = y;
            this.a_ = a;
            this.b_ = b;
            this.theta_ = theta;
        }

        Ellipse(double x, double y) {
            this(x, y, 0.0, 0.0, 0.0);
        }

        boolean isPoint() {
            return !(this.a_ > 0.0) && !(this.b_ > 0.0) || Double.isNaN(this.theta_);
        }

        boolean isCircle() {
            return this.a_ == this.b_;
        }

        double getMaxRadius() {
            return Math.max(this.a_, this.b_);
        }

        public String toString() {
            return "(x=" + this.x_ + ", y=" + this.y_ + ", a=" + this.a_ + ", b=" + this.b_ + ", theta=" + this.theta_;
        }
    }

    static class Match {
        final double score_;
        final double x1_;
        final double y1_;
        final double x2_;
        final double y2_;

        Match(double score, double x1, double y1, double x2, double y2) {
            this.score_ = score;
            this.x1_ = x1;
            this.y1_ = y1;
            this.x2_ = x2;
            this.y2_ = y2;
        }
    }
}

