/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.logging.Logger;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.pal.palError;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.EllipseCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.SkyPixellator;

public class EllipseSkyMatchEngine
extends AbstractSkyMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractSkyMatchEngine.SkyScaleParameter(SCALE_INFO)};
    private boolean recogniseCircles_;
    private static final DefaultValueInfo SCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of ellipse major radius; just used for tuning to set default pixel size");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Normalised distance between ellipses; range is 0 (concentric) - 2 (tangent)");
    private static final DefaultValueInfo ALPHA_INFO = new DefaultValueInfo("RA", Number.class, "Right ascension of centre");
    private static final DefaultValueInfo DELTA_INFO = new DefaultValueInfo("Dec", Number.class, "Declination of centre");
    private static final DefaultValueInfo MU_INFO = new DefaultValueInfo("Primary Radius", Number.class, "Length of ellipse semi-major axis");
    private static final DefaultValueInfo NU_INFO = new DefaultValueInfo("Secondary Radius", Number.class, "Length of ellipse semi-minor axis");
    private static final DefaultValueInfo ZETA_INFO = new DefaultValueInfo("Position Angle", Number.class, "Position angle - measured from north pole to primary axis, in direction of positive RA");
    private static final double NaN = Double.NaN;
    private static final Pal pal_;
    private static final Logger logger_;

    public EllipseSkyMatchEngine(SkyPixellator pixellator, double scale) {
        super(pixellator, scale);
        this.setRecogniseCircles(true);
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
    }

    @Override
    public double getScale() {
        return super.getScale();
    }

    public void setRecogniseCircles(boolean recogniseCircles) {
        this.recogniseCircles_ = recogniseCircles;
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{ALPHA_INFO, DELTA_INFO, MU_INFO, NU_INFO, ZETA_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        Match match = EllipseSkyMatchEngine.getMatch(this.toSkyEllipse(tuple1), this.toSkyEllipse(tuple2), false);
        return match == null ? -1.0 : match.score_;
    }

    @Override
    public double getScoreScale() {
        return 2.0;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        SkyEllipse ellipse = this.toSkyEllipse(tuple);
        return this.getBins(ellipse.alpha_, ellipse.delta_, ellipse.getMaxRadius());
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        double maxRadius = 0.0;
        for (NdRange inRange : inRanges) {
            Comparable[] maxs = inRange.getMaxs();
            maxRadius = Math.max(maxRadius, Math.max(EllipseSkyMatchEngine.getNumberValue(maxs[2]), EllipseSkyMatchEngine.getNumberValue(maxs[3])));
        }
        return EllipseSkyMatchEngine.createExtendedSkyBounds(inRanges[index], 0, 1, 2.0 * maxRadius);
    }

    @Override
    public String toString() {
        return "Sky Ellipses";
    }

    private SkyEllipse toSkyEllipse(Object[] tuple) {
        double alpha = EllipseSkyMatchEngine.getNumberValue(tuple[0]);
        double delta = EllipseSkyMatchEngine.getNumberValue(tuple[1]);
        double mu = EllipseSkyMatchEngine.getNumberValue(tuple[2]);
        double nu = EllipseSkyMatchEngine.getNumberValue(tuple[3]);
        double zeta = EllipseSkyMatchEngine.getNumberValue(tuple[4]);
        return EllipseSkyMatchEngine.createSkyEllipse(alpha, delta, mu, nu, zeta, this.recogniseCircles_);
    }

    static Match getMatch(SkyEllipse se1, SkyEllipse se2, boolean needPoints) {
        boolean isCenterInside2;
        double alpha1 = se1.alpha_;
        double delta1 = se1.delta_;
        double alpha2 = se2.alpha_;
        double delta2 = se2.delta_;
        double maxSep = se1.getMaxRadius() + se2.getMaxRadius();
        if (Math.abs(delta2 - delta1) > maxSep || EllipseSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2, delta2) > maxSep) {
            return null;
        }
        boolean isPoint1 = se1.isPoint();
        boolean isPoint2 = se2.isPoint();
        if (isPoint1 && isPoint2) {
            return EllipseSkyMatchEngine.normalizeAlpha(alpha1) == EllipseSkyMatchEngine.normalizeAlpha(alpha2) && EllipseSkyMatchEngine.normalizeDelta(delta1) == EllipseSkyMatchEngine.normalizeDelta(delta2) ? new Match(0.0, Double.NaN, Double.NaN, Double.NaN, Double.NaN) : null;
        }
        if (isPoint1) {
            double s = se2.getScaledDistance(alpha1, delta1);
            return s <= 1.0 ? new Match(s, Double.NaN, Double.NaN, alpha1, delta1) : null;
        }
        if (isPoint2) {
            double s = se1.getScaledDistance(alpha2, delta2);
            return s <= 1.0 ? new Match(s, alpha2, delta2, Double.NaN, Double.NaN) : null;
        }
        double sc1 = se1.getScaledDistance(alpha2, delta2);
        double sc2 = se2.getScaledDistance(alpha1, delta1);
        boolean isCenterInside1 = sc1 <= 1.0;
        boolean bl = isCenterInside2 = sc2 <= 1.0;
        if (isCenterInside1 && isCenterInside2) {
            return sc1 < sc2 ? new Match(sc1, alpha2, delta2, Double.NaN, Double.NaN) : new Match(sc2, Double.NaN, Double.NaN, alpha1, delta1);
        }
        if (isCenterInside1) {
            return new Match(sc1, alpha2, delta2, Double.NaN, Double.NaN);
        }
        if (isCenterInside2) {
            return new Match(sc2, Double.NaN, Double.NaN, alpha2, delta2);
        }
        if (se1.isCircle() && se2.isCircle() && !needPoints) {
            double mu1 = se1.getMaxRadius();
            double mu2 = se2.getMaxRadius();
            double s = EllipseSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2, delta2);
            double score = 1.0 + 0.5 * ((s - mu2) / mu1 + (s - mu1) / mu2);
            return new Match(score, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        }
        double[] pt = EllipseSkyMatchEngine.bisect(alpha1, delta1, alpha2, delta2);
        Projector projector = new Projector(pt[0], pt[1]);
        EllipseCartesianMatchEngine.Match cmatch = EllipseCartesianMatchEngine.getMatch(se1.project(projector), se2.project(projector), false);
        if (cmatch == null) {
            return null;
        }
        double score = cmatch.score_;
        if (needPoints) {
            double[] ad1 = projector.unproject(cmatch.x1_, cmatch.y1_);
            double[] ad2 = projector.unproject(cmatch.x2_, cmatch.y2_);
            return new Match(score, ad1[0], ad1[1], ad2[0], ad2[1]);
        }
        return new Match(score, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    static double[] bisect(double alpha1, double delta1, double alpha2, double delta2) {
        double[] p1 = pal_.Dcs2c(new AngleDR(alpha1, delta1));
        double[] p2 = pal_.Dcs2c(new AngleDR(alpha2, delta2));
        double[] pc = new double[]{(p1[0] + p2[0]) * 0.5, (p1[1] + p2[1]) * 0.5, (p1[2] + p2[2]) * 0.5};
        AngleDR cSph = pal_.Dcc2s(pc);
        return new double[]{cSph.getAlpha(), cSph.getDelta()};
    }

    private static double normalizeAlpha(double alpha) {
        double base = Math.PI * 2;
        return (alpha % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    private static double normalizeDelta(double delta) {
        return delta;
    }

    static SkyEllipse createSkyEllipse(double alpha, double delta, double mu, double nu, double zeta, boolean recogniseCircles) {
        if (recogniseCircles) {
            if (mu == nu) {
                return mu == 0.0 ? new PointSkyEllipse(alpha, delta) : new CircularSkyEllipse(alpha, delta, mu);
            }
            return new EccentricSkyEllipse(alpha, delta, mu, nu, zeta);
        }
        if (Double.isNaN(zeta) || Double.isNaN(mu) || Double.isNaN(nu)) {
            mu = 0.0;
            nu = 0.0;
            zeta = 0.0;
        }
        final boolean isPoint = mu == 0.0 && nu == 0.0;
        return new EccentricSkyEllipse(alpha, delta, mu, nu, zeta){

            @Override
            boolean isPoint() {
                return isPoint;
            }
        };
    }

    static {
        ALPHA_INFO.setUnitString("radians");
        ALPHA_INFO.setUCD("pos.eq.ra");
        DELTA_INFO.setUnitString("radians");
        DELTA_INFO.setUCD("pos.eq.dec");
        MU_INFO.setUnitString("radians");
        MU_INFO.setUCD("pos.angDistance");
        NU_INFO.setUnitString("radians");
        NU_INFO.setUCD("pos.angDistance");
        ZETA_INFO.setUnitString("radians");
        ZETA_INFO.setUCD("pos.posAng");
        SCALE_INFO.setUnitString("radians");
        SCALE_INFO.setUCD("pos.angDistance");
        SCALE_INFO.setNullable(false);
        pal_ = new Pal();
        logger_ = Logger.getLogger("uk.ac.starlink.table.join");
    }

    static class Projector {
        private final AngleDR ad0_;

        Projector(double alpha0, double delta0) {
            this.ad0_ = new AngleDR(alpha0, delta0);
        }

        public double[] project(double alpha, double delta) {
            try {
                AngleDR ad = pal_.Ds2tp(new AngleDR(alpha, delta), this.ad0_);
                return new double[]{ad.getAlpha(), ad.getDelta()};
            }
            catch (palError e) {
                return new double[]{Double.NaN, Double.NaN};
            }
        }

        public double[] unproject(double x, double y) {
            AngleDR ad = pal_.Dtp2s(new AngleDR(x, y), this.ad0_);
            return new double[]{ad.getAlpha(), ad.getDelta()};
        }
    }

    private static class PointSkyEllipse
    extends SkyEllipse {
        PointSkyEllipse(double alpha, double delta) {
            super(alpha, delta);
        }

        @Override
        boolean isPoint() {
            return true;
        }

        @Override
        boolean isCircle() {
            return true;
        }

        @Override
        double getMaxRadius() {
            return 0.0;
        }

        @Override
        double getScaledDistance(double alpha, double delta) {
            return alpha == this.alpha_ && delta == this.delta_ ? 0.0 : Double.POSITIVE_INFINITY;
        }

        @Override
        EllipseCartesianMatchEngine.Ellipse project(Projector projector) {
            double[] center = projector.project(this.alpha_, this.delta_);
            double x = center[0];
            double y = center[1];
            double a = 0.0;
            double b = 0.0;
            double theta = 0.0;
            return new EllipseCartesianMatchEngine.Ellipse(x, y, a, b, theta);
        }
    }

    private static class CircularSkyEllipse
    extends SkyEllipse {
        private final double mu_;

        CircularSkyEllipse(double alpha, double delta, double mu) {
            super(alpha, delta);
            this.mu_ = mu;
        }

        @Override
        boolean isPoint() {
            return false;
        }

        @Override
        boolean isCircle() {
            return true;
        }

        @Override
        double getMaxRadius() {
            return this.mu_;
        }

        @Override
        double getScaledDistance(double alpha, double delta) {
            return AbstractSkyMatchEngine.calculateSeparation(this.alpha_, this.delta_, alpha, delta) / this.mu_;
        }

        @Override
        EllipseCartesianMatchEngine.Ellipse project(Projector projector) {
            double[] center = projector.project(this.alpha_, this.delta_);
            double x = center[0];
            double y = center[1];
            double a = this.mu_;
            double b = this.mu_;
            double theta = 0.0;
            return new EllipseCartesianMatchEngine.Ellipse(x, y, a, b, theta);
        }
    }

    private static class EccentricSkyEllipse
    extends SkyEllipse {
        private final double mu_;
        private final double nu_;
        private final double zeta_;
        private double[][] northRot_;

        EccentricSkyEllipse(double alpha, double delta, double mu, double nu, double zeta) {
            super(alpha, delta);
            this.mu_ = mu;
            this.nu_ = nu;
            this.zeta_ = zeta;
        }

        @Override
        boolean isPoint() {
            return false;
        }

        @Override
        boolean isCircle() {
            return false;
        }

        @Override
        double getMaxRadius() {
            return Math.max(this.mu_, this.nu_);
        }

        @Override
        double getScaledDistance(double alpha, double delta) {
            boolean anti;
            double[] xyz = pal_.Dmxv(this.getNorthRotationMatrix(), pal_.Dcs2c(new AngleDR(alpha, delta)));
            double dm = Math.asin(Math.abs(xyz[0]));
            double dn = Math.asin(Math.abs(xyz[1]));
            boolean bl = anti = xyz[2] < 0.0;
            if (anti) {
                dm = Math.PI - dm;
                dn = Math.PI - dn;
            }
            double dx = dm / this.mu_;
            double dy = dn / this.nu_;
            return Math.sqrt(dx * dx + dy * dy);
        }

        @Override
        EllipseCartesianMatchEngine.Ellipse project(Projector projector) {
            double[] center = projector.project(this.alpha_, this.delta_);
            double x = center[0];
            double y = center[1];
            double a = this.mu_;
            double b = this.nu_;
            double theta = 1.5707963267948966 + this.zeta_;
            return new EllipseCartesianMatchEngine.Ellipse(x, y, a, b, theta);
        }

        private double[][] getNorthRotationMatrix() {
            if (this.northRot_ == null) {
                this.northRot_ = pal_.Deuler("zxz", 1.5707963267948966 + this.alpha_, 1.5707963267948966 - this.delta_, 1.5707963267948966 - this.zeta_);
            }
            return this.northRot_;
        }
    }

    static abstract class SkyEllipse {
        final double alpha_;
        final double delta_;

        protected SkyEllipse(double alpha, double delta) {
            this.alpha_ = alpha;
            this.delta_ = delta;
        }

        abstract boolean isPoint();

        abstract boolean isCircle();

        abstract double getMaxRadius();

        abstract double getScaledDistance(double var1, double var3);

        abstract EllipseCartesianMatchEngine.Ellipse project(Projector var1);
    }

    static class Match {
        final double score_;
        final double alpha1_;
        final double delta1_;
        final double alpha2_;
        final double delta2_;

        Match(double score, double alpha1, double delta1, double alpha2, double delta2) {
            this.score_ = score;
            this.alpha1_ = alpha1;
            this.delta1_ = delta1;
            this.alpha2_ = alpha2;
            this.delta2_ = delta2;
        }
    }
}

