/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class ErrorCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final DescribedValue[] matchParams_;
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between matched points, 0..1");
    private static final DefaultValueInfo ERROR_INFO = new DefaultValueInfo("Error", Number.class, "Per-object error radius");
    private static final DefaultValueInfo ERRSCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of per-object error distance; just used for tuning in conjunction with bin factor");

    public ErrorCartesianMatchEngine(int ndim, double scale) {
        super(ndim);
        this.ndim_ = ndim;
        this.matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERRSCALE_INFO)};
        this.setIsotropicScale(scale);
    }

    public void setScale(double scale) {
        super.setIsotropicScale(scale);
    }

    public double getScale() {
        return super.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ArrayList<ValueInfo> infoList = new ArrayList<ValueInfo>();
        for (int id = 0; id < this.ndim_; ++id) {
            infoList.add(this.createCoordinateInfo(id));
        }
        infoList.add(ERROR_INFO);
        return infoList.toArray(new ValueInfo[0]);
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cartesian with Errors";
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double score;
        double[] coords1 = this.getTupleCoords(tuple1);
        double[] coords2 = this.getTupleCoords(tuple2);
        double err = this.getTupleError(tuple1) + this.getTupleError(tuple2);
        double err2 = err * err;
        double dist2 = 0.0;
        for (int id = 0; id < this.ndim_; ++id) {
            double d = coords2[id] - coords1[id];
            if ((dist2 += d * d) <= err2) continue;
            return -1.0;
        }
        double d = score = err2 > 0.0 ? Math.sqrt(dist2 / err2) : 0.0;
        assert (score >= 0.0 && score <= 1.0);
        return score;
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getRadiusBins(this.getTupleCoords(tuple), this.getTupleError(tuple));
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        double maxRadius = 0.0;
        for (NdRange inRange : inRanges) {
            maxRadius = Math.max(maxRadius, this.getTupleError(inRange.getMaxs()));
        }
        return ErrorCartesianMatchEngine.createExtendedBounds(inRanges[index], 2.0 * maxRadius, ErrorCartesianMatchEngine.indexRange(0, this.ndim_));
    }

    private double[] getTupleCoords(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            coords[id] = ErrorCartesianMatchEngine.getNumberValue(tuple[id]);
        }
        return coords;
    }

    private double getTupleError(Object[] tuple) {
        return ErrorCartesianMatchEngine.getNumberValue(tuple[this.ndim_]);
    }
}

