/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.SkyPixellator;

public class ErrorSkyMatchEngine
extends AbstractSkyMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractSkyMatchEngine.SkyScaleParameter(SCALE_INFO)};
    private static final DefaultValueInfo SCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of per-object error distance; just used for tuning to set default pixel size");
    private static final DefaultValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Per-object error radius along a great circle");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between matched objects along a great circle (0..1)");

    public ErrorSkyMatchEngine(SkyPixellator pixellator, double scale) {
        super(pixellator, scale);
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
    }

    @Override
    public double getScale() {
        return super.getScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO, ERR_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        double alpha2;
        double delta1 = this.getDelta(tuple1);
        double delta2 = this.getDelta(tuple2);
        double maxerr = this.getError(tuple1) + this.getError(tuple2);
        if (Math.abs(delta1 - delta2) > maxerr) {
            return -1.0;
        }
        double alpha1 = this.getAlpha(tuple1);
        double sep = ErrorSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2 = this.getAlpha(tuple2), delta2);
        if (sep <= maxerr) {
            return maxerr > 0.0 ? sep / maxerr : 0.0;
        }
        return -1.0;
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getBins(this.getAlpha(tuple), this.getDelta(tuple), this.getError(tuple));
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        double maxRadius = 0.0;
        for (NdRange inRange : inRanges) {
            maxRadius = Math.max(maxRadius, this.getError(inRange.getMaxs()));
        }
        return ErrorSkyMatchEngine.createExtendedSkyBounds(inRanges[index], 0, 1, 2.0 * maxRadius);
    }

    @Override
    public String toString() {
        return "Sky with Errors";
    }

    private double getAlpha(Object[] tuple) {
        return ErrorSkyMatchEngine.getNumberValue(tuple[0]);
    }

    private double getDelta(Object[] tuple) {
        return ErrorSkyMatchEngine.getNumberValue(tuple[1]);
    }

    private double getError(Object[] tuple) {
        return ErrorSkyMatchEngine.getNumberValue(tuple[2]);
    }

    static {
        SCALE_INFO.setUnitString("radians");
        SCALE_INFO.setUCD("pos.angDistance");
        SCALE_INFO.setNullable(false);
        ERR_INFO.setUnitString("radians");
        ERR_INFO.setUCD("pos.angDistance");
        ERR_INFO.setNullable(false);
    }
}

