/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.SkyPixellator;

public class FixedSkyMatchEngine
extends AbstractSkyMatchEngine {
    private double separation_;
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractSkyMatchEngine.SkyScaleParameter(SEP_INFO)};
    private static final DefaultValueInfo SEP_INFO = new DefaultValueInfo("Max Error", Number.class, "Maximum separation along a great circle");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Distance between matched objects along a great circle");

    public FixedSkyMatchEngine(SkyPixellator pixellator, double separation) {
        super(pixellator, separation);
    }

    public void setSeparation(double separation) {
        this.setScale(separation);
    }

    public double getSeparation() {
        return this.getScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return FixedSkyMatchEngine.matchScore(this.getAlpha(tuple1), this.getDelta(tuple1), this.getAlpha(tuple2), this.getDelta(tuple2), this.getSeparation());
    }

    @Override
    public double getScoreScale() {
        return FixedSkyMatchEngine.maxScore(this.getSeparation());
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getBins(this.getAlpha(tuple), this.getDelta(tuple), this.getSeparation() * 0.5);
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        return FixedSkyMatchEngine.createExtendedSkyBounds(inRanges[index], 0, 1, this.getSeparation());
    }

    @Override
    public String toString() {
        return "Sky";
    }

    private double getAlpha(Object[] tuple) {
        return FixedSkyMatchEngine.getNumberValue(tuple[0]);
    }

    private double getDelta(Object[] tuple) {
        return FixedSkyMatchEngine.getNumberValue(tuple[1]);
    }

    static {
        SEP_INFO.setUnitString("radians");
        SEP_INFO.setUCD("pos.angDistance");
        SCORE_INFO.setUnitString("arcsec");
        SCORE_INFO.setUCD("pos.angDistance");
    }
}

