/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.SkyPixellator;

public abstract class HealpixSkyPixellator
implements SkyPixellator {
    private final DescribedValue healpixKParam_;
    private final int maxK_;
    private double scale_;
    private int healpixK_;

    protected HealpixSkyPixellator(int maxK) {
        this.maxK_ = maxK;
        String kdesc = "Controls sky pixel size. Legal range 0 - " + maxK + ". " + "0 is 60deg, 20 is 0.2\".";
        DefaultValueInfo kInfo = new DefaultValueInfo("HEALPix k", Integer.class, kdesc);
        kInfo.setNullable(true);
        this.healpixKParam_ = new HealpixKParameter(kInfo);
        this.setHealpixK(-1);
    }

    public int getMaxK() {
        return this.maxK_;
    }

    @Override
    public void setScale(double scale) {
        this.scale_ = scale;
        this.configureK(this.getHealpixK());
    }

    @Override
    public double getScale() {
        return this.scale_;
    }

    @Override
    public DescribedValue getTuningParameter() {
        return this.healpixKParam_;
    }

    public void setHealpixK(int healpixK) {
        int maxK = this.getMaxK();
        if (healpixK < -1 || healpixK > maxK) {
            throw new IllegalArgumentException("HEALPix k " + healpixK + " out of range 0.." + maxK);
        }
        this.healpixK_ = healpixK;
        this.configureK(this.getHealpixK());
    }

    public int getHealpixK() {
        if (this.healpixK_ >= 0) {
            return this.healpixK_;
        }
        double scale = this.getScale();
        return scale > 0.0 ? this.calculateDefaultK(scale) : -1;
    }

    protected abstract void configureK(int var1);

    public abstract int calculateDefaultK(double var1);

    private class HealpixKParameter
    extends DescribedValue {
        HealpixKParameter(ValueInfo info) {
            super(info);
        }

        @Override
        public Object getValue() {
            int k = HealpixSkyPixellator.this.getHealpixK();
            return k >= 0 ? new Integer(k) : null;
        }

        @Override
        public void setValue(Object value) {
            HealpixSkyPixellator.this.setHealpixK(value == null ? -1 : (Integer)value);
        }
    }
}

