/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class IsotropicCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final DescribedValue[] matchParams_;
    private static final ValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Maximum Cartesian separation for match");
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Spatial distance between matched points");

    public IsotropicCartesianMatchEngine(int ndim, double err, boolean normaliseScores) {
        super(ndim);
        this.ndim_ = ndim;
        this.matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERR_INFO)};
        this.setIsotropicScale(err);
    }

    public void setError(double err) {
        this.setIsotropicScale(err);
    }

    public double getError() {
        return this.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return IsotropicCartesianMatchEngine.matchScore(this.ndim_, this.toCoords(tuple1), this.toCoords(tuple2), this.getError());
    }

    @Override
    public double getScoreScale() {
        return this.getError();
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getRadiusBins(this.toCoords(tuple), this.getError() * 0.5);
    }

    @Override
    public boolean canBoundMatch() {
        return true;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        return IsotropicCartesianMatchEngine.createExtendedBounds(inRanges[index], this.getError(), IsotropicCartesianMatchEngine.indexRange(0, this.ndim_));
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cartesian";
    }

    private double[] toCoords(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            coords[id] = IsotropicCartesianMatchEngine.getNumberValue(tuple[id]);
        }
        return coords;
    }
}

