/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.BitSet;
import java.util.Iterator;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.TreeSetLinkSet;

public abstract class JoinType {
    private final String name_;
    private final String longName_;
    public static final JoinType _1AND2 = new JoinType("1and2", "1 and 2"){

        @Override
        public String getDescription() {
            return "An output row for each row represented in both input tables (INNER JOIN)";
        }

        @Override
        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            return links;
        }

        @Override
        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        @Override
        public boolean getUsedMatchFlag() {
            return true;
        }
    };
    public static final JoinType _1OR2 = new JoinType("1or2", "1 or 2"){

        @Override
        public String getDescription() {
            return "An output row for each row represented in either or both of the input tables (FULL OUTER JOIN)";
        }

        @Override
        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            int iTable;
            BitSet[] present = new BitSet[2];
            for (iTable = 0; iTable < 2; ++iTable) {
                present[iTable] = JoinType.getInclusion(links, iTable);
            }
            for (iTable = 0; iTable < 2; ++iTable) {
                for (int iRow = 0; iRow < rowCounts[iTable]; ++iRow) {
                    if (present[iTable].get(iRow)) continue;
                    links.addLink(new RowLink(new RowRef(iTable, iRow)));
                }
            }
            return links;
        }

        @Override
        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        @Override
        public boolean getUsedMatchFlag() {
            return true;
        }
    };
    public static final JoinType _ALL1 = new AllType("all1", "All from 1", 0);
    public static final JoinType _ALL2 = new AllType("all2", "All from 2", 1);
    public static final JoinType _2NOT1 = new NotType("2not1", "2 not 1", 0);
    public static final JoinType _1NOT2 = new NotType("1not2", "1 not 2", 1);
    public static final JoinType _1XOR2 = new JoinType("1xor2", "1 xor 2"){

        @Override
        public String getDescription() {
            return "An output row only for rows represented in one of the input tables but not the other one";
        }

        @Override
        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            int iTable;
            BitSet[] present = new BitSet[2];
            for (iTable = 0; iTable < 2; ++iTable) {
                present[iTable] = JoinType.getInclusion(links, iTable);
            }
            links = JoinType.createLinkSet();
            for (iTable = 0; iTable < 2; ++iTable) {
                for (int iRow = 0; iRow < rowCounts[iTable]; ++iRow) {
                    if (present[iTable].get(iRow)) continue;
                    links.addLink(new RowLink(new RowRef(iTable, iRow)));
                }
            }
            return links;
        }

        @Override
        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        @Override
        public boolean getUsedMatchFlag() {
            return false;
        }
    };

    private JoinType(String name, String longName) {
        this.name_ = name;
        this.longName_ = longName;
    }

    public abstract LinkSet processLinks(LinkSet var1, int[] var2);

    public abstract boolean[] getUsedTableFlags();

    public abstract boolean getUsedMatchFlag();

    public String getName() {
        return this.name_;
    }

    public abstract String getDescription();

    public String toString() {
        return this.longName_;
    }

    public static JoinType[] getPairTypes() {
        return new JoinType[]{_1AND2, _1OR2, _ALL1, _ALL2, _1NOT2, _2NOT1, _1XOR2};
    }

    private static LinkSet createLinkSet() {
        return new TreeSetLinkSet();
    }

    private static BitSet getInclusion(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                present.set(Tables.checkedLongToInt(ref.getRowIndex()));
            }
        }
        return present;
    }

    private static class NotType
    extends JoinType {
        final int yesTable_;
        final int noTable_;

        NotType(String name, String longName, int noTable) {
            super(name, longName);
            this.noTable_ = noTable;
            this.yesTable_ = 1 - this.noTable_;
        }

        @Override
        public String getDescription() {
            String[] ordinals = new String[]{"first", "second"};
            return "An output row only for rows which appear in the " + ordinals[this.yesTable_] + " table but are not matched in the " + ordinals[this.noTable_] + " table";
        }

        @Override
        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet matched = new BitSet();
            Iterator it = links.iterator();
            while (it.hasNext()) {
                RowLink link = (RowLink)it.next();
                int nref = link.size();
                long noRow = -1L;
                long yesRow = -1L;
                for (int i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    if (ref.getTableIndex() == this.noTable_) {
                        noRow = ref.getRowIndex();
                        continue;
                    }
                    if (ref.getTableIndex() != this.yesTable_) continue;
                    yesRow = ref.getRowIndex();
                }
                if (noRow < 0L || yesRow < 0L) continue;
                matched.set(Tables.checkedLongToInt(yesRow));
            }
            links = JoinType.createLinkSet();
            for (int irow = 0; irow < rowCounts[this.yesTable_]; ++irow) {
                if (matched.get(irow)) continue;
                links.addLink(new RowLink(new RowRef(this.yesTable_, irow)));
            }
            return links;
        }

        @Override
        public boolean[] getUsedTableFlags() {
            boolean[] flags = new boolean[2];
            flags[this.noTable_] = false;
            flags[this.yesTable_] = true;
            return flags;
        }

        @Override
        public boolean getUsedMatchFlag() {
            return false;
        }
    }

    private static class AllType
    extends JoinType {
        final int iTable_;

        AllType(String name, String longName, int iTable) {
            super(name, longName);
            this.iTable_ = iTable;
        }

        @Override
        public String getDescription() {
            return new StringBuffer().append("An output row for each matched or unmatched row in ").append("table ").append(this.iTable_ + 1).append(" (").append(this.iTable_ == 0 ? "LEFT" : "RIGHT").append(" OUTER JOIN)").toString();
        }

        @Override
        public LinkSet processLinks(LinkSet links, int[] rowCounts) {
            BitSet present = JoinType.getInclusion(links, this.iTable_);
            for (int irow = 0; irow < rowCounts[this.iTable_]; ++irow) {
                if (present.get(irow)) continue;
                links.addLink(new RowLink(new RowRef(this.iTable_, irow)));
            }
            return links;
        }

        @Override
        public boolean[] getUsedTableFlags() {
            return new boolean[]{true, true};
        }

        @Override
        public boolean getUsedMatchFlag() {
            return true;
        }
    }
}

