/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.RowMatcher;

public enum PairMode {
    ALL(true, "All matches"){

        @Override
        LinkSet findPairMatches(RowMatcher rowMatcher) throws IOException, InterruptedException {
            return rowMatcher.findAllPairs(0, 1, false);
        }
    }
    ,
    BEST(false, "Best match, symmetric"){

        @Override
        LinkSet findPairMatches(RowMatcher rowMatcher) throws IOException, InterruptedException {
            LinkSet lset = rowMatcher.findAllPairs(0, 1, true);
            return rowMatcher.eliminateMultipleRowEntries(lset);
        }
    }
    ,
    BEST1(true, "Best match for each Table 1 row"){

        @Override
        LinkSet findPairMatches(RowMatcher rowMatcher) throws IOException, InterruptedException {
            NdRange range = new NdRange(rowMatcher.getPairColumnCount(0, 1));
            return rowMatcher.scanForPairs(1, 0, range, true);
        }
    }
    ,
    BEST2(true, "Best match for each Table 2 row"){

        @Override
        LinkSet findPairMatches(RowMatcher rowMatcher) throws IOException, InterruptedException {
            NdRange range = new NdRange(rowMatcher.getPairColumnCount(0, 1));
            return rowMatcher.scanForPairs(0, 1, range, true);
        }
    };

    private final boolean mayProduceGroups_;
    private final String summary_;

    private PairMode(boolean mayProduceGroups, String summary) {
        this.mayProduceGroups_ = mayProduceGroups;
        this.summary_ = summary;
    }

    public boolean mayProduceGroups() {
        return this.mayProduceGroups_;
    }

    public String getSummary() {
        return this.summary_;
    }

    abstract LinkSet findPairMatches(RowMatcher var1) throws IOException, InterruptedException;
}

