/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import gov.fnal.eag.healpix.PixTools;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import uk.ac.starlink.table.join.HealpixSkyPixellator;

public class PixtoolsHealpixSkyPixellator
extends HealpixSkyPixellator {
    private final PixTools pixTools_;
    private final int scheme_;
    private int healpixK_;
    private long nside_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.join");
    private static final int DEFAULT_SCALE_FACTOR = 8;

    public PixtoolsHealpixSkyPixellator(boolean nested) {
        super(20);
        this.scheme_ = nested ? 1 : 0;
        this.pixTools_ = PixTools.getInstance();
    }

    public PixtoolsHealpixSkyPixellator() {
        this(false);
    }

    @Override
    public Object[] getPixels(double alpha, double delta, double radius) {
        double theta = 1.5707963267948966 - delta;
        Vector3d vec = this.pixTools_.Ang2Vec(theta, alpha);
        ArrayList pixList = this.pixTools_.query_disc(this.nside_, vec, radius, this.scheme_, 1);
        return pixList.toArray();
    }

    @Override
    protected void configureK(int k) {
        this.nside_ = 1 << k;
    }

    @Override
    public int calculateDefaultK(double scale) {
        double pixelSize = 8.0 * scale;
        double pixelSizeArcSec = pixelSize * 206264.80624709636;
        if (pixelSizeArcSec < 0.21) {
            pixelSizeArcSec = 0.21;
            logger_.info("pixtools: nside cannot be bigger than 1048576");
        }
        long nside = this.pixTools_.GetNSide(pixelSizeArcSec);
        return (int)Math.round(Math.log(nside) / Math.log(2.0));
    }
}

