/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

class Profiler {
    private final Runtime runtime_ = Runtime.getRuntime();
    private long resetUsed_;
    private long resetTime_;
    private long gcTime_;

    public void reset() {
        this.gcTime_ = 0L;
        this.resetTime_ = System.currentTimeMillis();
        this.resetUsed_ = this.getCurrentUsedMemory();
    }

    public String report() {
        long usedMem = this.getCurrentUsedMemory();
        long remainingMem = this.runtime_.maxMemory() - usedMem;
        long elapsedTime = System.currentTimeMillis() - this.resetTime_;
        return new StringBuffer().append("Mem: ").append(this.formatMemory(this.resetUsed_)).append(" -> ").append(this.formatMemory(usedMem)).append("; Time: ").append(this.formatTime(elapsedTime)).append(" (").append("gc ").append(this.formatTime(this.gcTime_)).append(", remaining ").append(this.formatMemory(remainingMem)).append(")").toString();
    }

    public String formatMemory(long nbyte) {
        int megas = (int)Math.round((double)nbyte / 1024.0 / 1024.0);
        return megas + "M";
    }

    public String formatTime(long millis) {
        int tenths = Math.round(millis / 100L);
        return tenths / 10 + "." + tenths % 10 + "s";
    }

    public long getCurrentUsedMemory() {
        long startGc = System.currentTimeMillis();
        this.runtime_.gc();
        this.gcTime_ += System.currentTimeMillis() - startGc;
        return this.runtime_.totalMemory() - this.runtime_.freeMemory();
    }
}

