/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowRef;

abstract class RowLinkTable
extends WrapperStarTable {
    private final StarTable base_;
    private final int iTable_;
    private final ColumnInfo[] colInfos_;
    private Boolean hasBlanks_;

    RowLinkTable(StarTable base, int iTable) {
        super(base);
        this.base_ = base;
        this.iTable_ = iTable;
        this.colInfos_ = new ColumnInfo[this.getColumnCount()];
    }

    @Override
    public boolean isRandom() {
        return false;
    }

    @Override
    public Object getCell(long irow, int icol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getRow(long irow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    public abstract Iterator getLinkIterator() throws IOException;

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        if (this.hasBlanks_ == null) {
            boolean hasBlanks = false;
            try {
                Iterator it = this.getLinkIterator();
                while (it.hasNext() && !hasBlanks) {
                    RowLink link = (RowLink)it.next();
                    if (this.getBaseRowIndex(link) >= 0L) continue;
                    hasBlanks = true;
                }
                this.hasBlanks_ = hasBlanks;
            }
            catch (IOException e) {
                this.hasBlanks_ = Boolean.TRUE;
            }
        }
        if (this.colInfos_[icol] == null) {
            this.colInfos_[icol] = new ColumnInfo(super.getColumnInfo(icol));
            if (this.hasBlanks_.booleanValue()) {
                this.colInfos_[icol].setNullable(true);
            }
        }
        return this.colInfos_[icol];
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return this.base_.isRandom() ? new RandomLinkRowSequence() : new SequentialLinkRowSequence();
    }

    private long getBaseRowIndex(RowLink link) {
        int nr = link.size();
        for (int ir = 0; ir < nr; ++ir) {
            RowRef ref = link.getRef(ir);
            if (ref.getTableIndex() != this.iTable_) continue;
            return ref.getRowIndex();
        }
        return -1L;
    }

    public Object getCell(RowLink link, int icol) throws IOException {
        long jrow = this.getBaseRowIndex(link);
        return jrow >= 0L ? this.base_.getCell(jrow, icol) : null;
    }

    public Object[] getRow(RowLink link) throws IOException {
        long jrow = this.getBaseRowIndex(link);
        return jrow >= 0L ? this.base_.getRow(jrow) : new Object[this.getColumnCount()];
    }

    private class SequentialLinkRowSequence
    extends WrapperRowSequence {
        final Iterator linkIt_;
        long irow_;

        SequentialLinkRowSequence() throws IOException {
            super(RowLinkTable.this.base_.getRowSequence());
            this.irow_ = -1L;
            this.linkIt_ = RowLinkTable.this.getLinkIterator();
        }

        @Override
        public boolean next() throws IOException {
            if (this.linkIt_.hasNext()) {
                RowLink link = (RowLink)this.linkIt_.next();
                return this.advanceTo(RowLinkTable.this.getBaseRowIndex(link));
            }
            return false;
        }

        private boolean advanceTo(long target) throws IOException {
            if (this.irow_ > target) {
                throw new IOException("Badly ordered RowLinks");
            }
            boolean hasNext = true;
            while (this.irow_ < target && hasNext) {
                ++this.irow_;
                hasNext = this.baseSeq.next();
            }
            return hasNext;
        }
    }

    private class RandomLinkRowSequence
    implements RowSequence {
        final Iterator linkIt_;
        RowLink link_;

        RandomLinkRowSequence() throws IOException {
            this.linkIt_ = RowLinkTable.this.getLinkIterator();
        }

        @Override
        public boolean next() {
            if (this.linkIt_.hasNext()) {
                this.link_ = (RowLink)this.linkIt_.next();
                return true;
            }
            this.link_ = null;
            return false;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return RowLinkTable.this.getCell(this.link_, icol);
        }

        @Override
        public Object[] getRow() throws IOException {
            return RowLinkTable.this.getRow(this.link_);
        }

        @Override
        public void close() {
        }
    }
}

