/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.Binners;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MultiJoinType;
import uk.ac.starlink.table.join.NdRange;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.table.join.PairMode;
import uk.ac.starlink.table.join.PairsRowLink;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressRowSequence;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.TreeSetLinkSet;

public class RowMatcher {
    private final MatchEngine engine;
    private final StarTable[] tables;
    private final int nTable;
    private ProgressIndicator indicator = new NullProgressIndicator();
    private long startTime;

    public RowMatcher(MatchEngine engine, StarTable[] tables) {
        this.engine = engine;
        this.tables = tables;
        this.nTable = tables.length;
    }

    public void setIndicator(ProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public ProgressIndicator getIndicator() {
        return this.indicator;
    }

    public LinkSet createLinkSet() {
        return new TreeSetLinkSet();
    }

    public LinkSet findPairMatches(PairMode pairMode) throws IOException, InterruptedException {
        if (this.nTable != 2) {
            throw new IllegalStateException("findPairMatches only makes sense for 2 tables");
        }
        this.startMatch();
        LinkSet pairs = pairMode.findPairMatches(this);
        this.endMatch();
        return pairs;
    }

    LinkSet findAllPairs(int index1, int index2, boolean bestOnly) throws IOException, InterruptedException {
        NdRange range;
        int indexR;
        int indexS;
        int ncol = this.getPairColumnCount(index1, index2);
        if (!this.tables[index1].isRandom() && !this.tables[index2].isRandom()) {
            throw new IllegalArgumentException("Neither table random-access");
        }
        if (!this.tables[index1].isRandom()) {
            assert (this.tables[index2].isRandom());
            indexS = index1;
            indexR = index2;
            range = new NdRange(ncol);
        } else if (!this.tables[index2].isRandom()) {
            assert (this.tables[index1].isRandom());
            indexS = index2;
            indexR = index1;
            range = new NdRange(ncol);
        } else {
            Intersection intersect = this.getIntersection(new int[]{index1, index2});
            range = intersect.range_;
            if (range == null) {
                return this.createLinkSet();
            }
            long inRangeCount1 = intersect.inRangeCounts_[0];
            long inRangeCount2 = intersect.inRangeCounts_[1];
            if (inRangeCount1 < inRangeCount2) {
                indexR = index1;
                indexS = index2;
            } else {
                indexR = index2;
                indexS = index1;
            }
        }
        return this.scanForPairs(indexR, indexS, range, bestOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkSet scanForPairs(int indexR, int indexS, NdRange range, boolean bestOnly) throws IOException, InterruptedException {
        ProgressRowSequence rseq = new ProgressRowSequence(this.tables[indexR], this.indicator, "Binning rows for table " + (indexR + 1));
        LongBinner binner = Binners.createLongBinner(this.tables[indexR].getRowCount());
        long nrow = 0L;
        long nref = 0L;
        long nexclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                if (range.isInside(row)) {
                    Object[] keys = this.engine.getBins(row);
                    int nkey = keys.length;
                    for (int ikey = 0; ikey < nkey; ++ikey) {
                        binner.addItem(keys[ikey], lrow);
                    }
                    nref += (long)nkey;
                } else {
                    ++nexclude;
                }
                ++nrow;
                ++lrow;
            }
            assert (nrow == this.tables[indexR].getRowCount());
        }
        finally {
            rseq.close();
        }
        if (nexclude > 0L) {
            this.indicator.logMessage(nexclude + "/" + nrow + " rows excluded " + "(out of match region)");
        }
        long nbin = binner.getBinCount();
        this.indicator.logMessage(nref + " row refs for " + nrow + " rows in " + nbin + " bins");
        this.indicator.logMessage("(average bin occupancy " + (float)nref / (float)nbin + ")");
        LinkSet linkSet = this.createLinkSet();
        ProgressRowSequence sseq = new ProgressRowSequence(this.tables[indexS], this.indicator, "Scanning rows for table " + (indexS + 1));
        try {
            long isrow = 0L;
            while (sseq.nextProgress()) {
                Object[] srowData = sseq.getRow();
                if (range.isInside(srowData)) {
                    Object[] keys = this.engine.getBins(srowData);
                    int nkey = keys.length;
                    HashSet<Long> rrowSet = new HashSet<Long>();
                    for (int ikey = 0; ikey < nkey; ++ikey) {
                        long[] rrows = binner.getLongs(keys[ikey]);
                        if (rrows == null) continue;
                        for (int ir = 0; ir < rrows.length; ++ir) {
                            rrowSet.add(new Long(rrows[ir]));
                        }
                    }
                    long[] rrows = new long[rrowSet.size()];
                    int ir = 0;
                    Iterator it = rrowSet.iterator();
                    while (it.hasNext()) {
                        rrows[ir++] = (Long)it.next();
                    }
                    Arrays.sort(rrows);
                    ArrayList<RowLink2> linkList = new ArrayList<RowLink2>(1);
                    double bestScore = Double.MAX_VALUE;
                    for (ir = 0; ir < rrows.length; ++ir) {
                        long irrow = rrows[ir];
                        Object[] rrowData = this.tables[indexR].getRow(irrow);
                        double score = this.engine.matchScore(srowData, rrowData);
                        if (!(score >= 0.0) || bestOnly && !(score < bestScore)) continue;
                        RowRef rref = new RowRef(indexR, irrow);
                        RowRef sref = new RowRef(indexS, isrow);
                        RowLink2 pairLink = new RowLink2(rref, sref);
                        pairLink.setScore(score);
                        if (bestOnly) {
                            bestScore = score;
                            linkList.clear();
                        }
                        linkList.add(pairLink);
                        assert (!bestOnly || linkList.size() == 1);
                    }
                    for (RowLink2 pairLink : linkList) {
                        assert (!linkSet.containsLink(pairLink));
                        linkSet.addLink(pairLink);
                    }
                }
                ++isrow;
            }
        }
        finally {
            sseq.close();
        }
        return linkSet;
    }

    public LinkSet findMultiPairMatches(int index0, boolean bestOnly, MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (joinTypes.length != this.nTable) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable);
        }
        this.startMatch();
        LinkSet possibleLinks = this.getPossibleMultiPairLinks(index0);
        LinkSet multiLinks = this.findMultiPairMatches(possibleLinks, index0, bestOnly);
        LinkSet[] missing = new LinkSet[this.nTable];
        for (i = 0; i < this.nTable; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(multiLinks, i);
        }
        for (i = 0; i < this.nTable; ++i) {
            if (missing[i] == null) continue;
            Iterator it = missing[i].iterator();
            while (it.hasNext()) {
                multiLinks.addLink((RowLink)it.next());
            }
            missing[i] = null;
        }
        Iterator it = multiLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return multiLinks;
    }

    public LinkSet findGroupMatches(MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (this.nTable < 2) {
            throw new IllegalStateException("Find matches only makes sense for multiple tables");
        }
        if (joinTypes.length != this.nTable) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable);
        }
        this.startMatch();
        LinkSet pairs = this.findPairs(this.getAllPossibleLinks());
        this.eliminateInternalLinks(pairs);
        LinkSet links = this.agglomerateLinks(pairs);
        pairs = null;
        this.eliminateInternalLinks(links);
        LinkSet[] missing = new LinkSet[this.nTable];
        for (i = 0; i < this.nTable; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(links, i);
        }
        for (i = 0; i < this.nTable; ++i) {
            if (missing[i] == null) continue;
            Iterator it = missing[i].iterator();
            while (it.hasNext()) {
                links.addLink((RowLink)it.next());
            }
            missing[i] = null;
        }
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return links;
    }

    public LinkSet findInternalMatches(boolean includeSingles) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable != 1) {
            throw new IllegalStateException("Internal matches only make sense with a single table");
        }
        this.startMatch();
        LinkSet links = this.findPairs(this.getAllPossibleInternalLinks(0));
        links = this.agglomerateLinks(links);
        if (includeSingles) {
            Iterator it = this.missingSingles(links, 0).iterator();
            while (it.hasNext()) {
                links.addLink((RowLink)it.next());
                it.remove();
            }
        }
        this.endMatch();
        return links;
    }

    private LinkSet findPairs(LinkSet possibleLinks) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating pairs");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                int i;
                Object[][] binnedRows = new Object[nref][];
                for (i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    StarTable table = this.tables[ref.getTableIndex()];
                    binnedRows[i] = table.getRow(ref.getRowIndex());
                }
                for (i = 0; i < nref; ++i) {
                    for (int j = 0; j < i; ++j) {
                        double score;
                        RowLink2 pair = new RowLink2(link.getRef(i), link.getRef(j));
                        if (pairs.containsLink(pair) || !((score = this.engine.matchScore(binnedRows[i], binnedRows[j])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        return pairs;
    }

    private LinkSet getAllPossibleLinks() throws IOException, InterruptedException {
        NdRange range = new NdRange(this.tables[0].getColumnCount());
        ObjectBinner binner = Binners.createObjectBinner();
        long totalRows = 0L;
        for (int itab = 0; itab < this.nTable; ++itab) {
            this.binRows(itab, range, binner, true);
            totalRows += this.tables[itab].getRowCount();
        }
        long nBin = binner.getBinCount();
        this.indicator.logMessage("Average bin count per row: " + (float)((double)nBin / (double)totalRows));
        LinkSet links = this.createLinkSet();
        this.binsToLinks(binner, links);
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkSet getAllPossibleInternalLinks(int itable) throws IOException, InterruptedException {
        StarTable table = this.tables[itable];
        long nRow = table.getRowCount();
        LongBinner binner = Binners.createLongBinner(nRow);
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Binning rows");
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                Object[] keys = this.engine.getBins(row);
                int nkey = keys.length;
                for (int ikey = 0; ikey < nkey; ++ikey) {
                    binner.addItem(keys[ikey], lrow);
                }
                ++lrow;
            }
        }
        finally {
            rseq.close();
        }
        long nBin = binner.getBinCount();
        this.indicator.logMessage("Average bin count per row: " + (float)((double)nBin / (double)nRow));
        LinkSet links = this.createLinkSet();
        this.binsToInternalLinks(binner, links, itable);
        return links;
    }

    private Intersection getIntersection(int[] iTables) throws IOException, InterruptedException {
        NdRange range;
        long[] inRangeCounts;
        block10: {
            int ncol = this.tables[iTables[0]].getColumnCount();
            int nt = iTables.length;
            inRangeCounts = new long[nt];
            for (int iTable = 0; iTable < nt; ++iTable) {
                int index = iTables[iTable];
                inRangeCounts[iTable] = this.tables[index].getRowCount();
            }
            if (this.engine.canBoundMatch() && iTables.length > 1) {
                this.indicator.logMessage("Attempt to locate restricted common region");
                try {
                    int iTable;
                    NdRange[] inRanges = new NdRange[nt];
                    for (int iTable2 = 0; iTable2 < nt; ++iTable2) {
                        int index = iTables[iTable2];
                        inRanges[iTable2] = this.readTupleRange(index);
                    }
                    NdRange[] extRanges = new NdRange[nt];
                    for (iTable = 0; iTable < nt; ++iTable) {
                        extRanges[iTable] = this.engine.getMatchBounds(inRanges, iTable);
                    }
                    range = extRanges[0];
                    for (iTable = 1; iTable < nt; ++iTable) {
                        range = NdRange.intersection(range, extRanges[iTable]);
                    }
                    if (range != null) {
                        this.indicator.logMessage("Potential match region: " + range);
                        for (iTable = 0; iTable < nt; ++iTable) {
                            int index = iTables[iTable];
                            inRangeCounts[iTable] = this.countInRange(index, range);
                        }
                        break block10;
                    }
                    this.indicator.logMessage("No region overlap - matches not possible");
                    return new Intersection(null, new long[iTables.length]);
                }
                catch (ClassCastException e) {
                    this.indicator.logMessage("Common region location failed (incompatible value types)");
                    range = new NdRange(ncol);
                }
            } else {
                range = new NdRange(ncol);
            }
        }
        return new Intersection(range, inRangeCounts);
    }

    private void eliminateInternalLinks(LinkSet links) throws InterruptedException {
        Object[] refs = new RowRef[this.nTable];
        LinkSet replacements = this.createLinkSet();
        this.indicator.startStage("Eliminating internal links");
        double nLink = links.size();
        int iLink = 0;
        int nReplace = 0;
        int nRemove = 0;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            if (link.size() > 1) {
                Arrays.fill(refs, null);
                boolean dup = false;
                for (int i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    int iTable = ref.getTableIndex();
                    if (refs[iTable] == null) {
                        refs[iTable] = ref;
                        continue;
                    }
                    dup = true;
                }
                if (dup) {
                    it.remove();
                    ArrayList<Object> repRefs = new ArrayList<Object>();
                    for (int i = 0; i < this.nTable; ++i) {
                        if (refs[i] == null) continue;
                        repRefs.add(refs[i]);
                    }
                    if (repRefs.size() > 1) {
                        replacements.addLink(new RowLink(repRefs));
                        ++nReplace;
                    } else {
                        ++nRemove;
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        if (nReplace > 0) {
            this.indicator.logMessage("Internal links replaced: " + nReplace);
        }
        if (nRemove > 0) {
            this.indicator.logMessage("Internal links removed: " + nRemove);
        }
        it = replacements.iterator();
        while (it.hasNext()) {
            RowLink repLink = (RowLink)it.next();
            links.addLink(repLink);
            it.remove();
        }
    }

    private LinkSet missingSingles(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                present.set(RowMatcher.checkedLongToInt(ref.getRowIndex()));
            }
        }
        int nrow = RowMatcher.checkedLongToInt(this.tables[iTable].getRowCount());
        LinkSet singles = this.createLinkSet();
        for (int iRow = 0; iRow < nrow; ++iRow) {
            if (present.get(iRow)) continue;
            singles.addLink(new RowLink(new RowRef(iTable, iRow)));
        }
        return singles;
    }

    private LinkSet getPossibleMultiPairLinks(int index0) throws IOException, InterruptedException {
        NdRange range;
        int ncol = this.tables[index0].getColumnCount();
        if (this.engine.canBoundMatch()) {
            this.indicator.logMessage("Attempt to locate restricted common region");
            try {
                NdRange[] inRanges = new NdRange[this.nTable];
                for (int i = 0; i < this.nTable; ++i) {
                    inRanges[i] = this.readTupleRange(i);
                }
                NdRange[] extRanges = new NdRange[this.nTable];
                for (int i = 0; i < this.nTable; ++i) {
                    extRanges[i] = this.engine.getMatchBounds(inRanges, i);
                }
                NdRange unionOthers = null;
                for (int i = 0; i < this.nTable; ++i) {
                    if (i == index0) continue;
                    unionOthers = unionOthers == null ? extRanges[i] : NdRange.union(unionOthers, extRanges[i]);
                }
                range = NdRange.intersection(extRanges[index0], unionOthers);
                this.indicator.logMessage("Potential match region: " + range);
            }
            catch (ClassCastException e) {
                this.indicator.logMessage("Region location failed (incompatible value types)");
                range = new NdRange(ncol);
            }
        } else {
            range = new NdRange(ncol);
        }
        ObjectBinner binner = Binners.createObjectBinner();
        this.binRows(index0, range, binner, true);
        for (int itab = 0; itab < this.nTable; ++itab) {
            if (itab == index0) continue;
            this.binRows(itab, range, binner, false);
        }
        LinkSet linkSet = this.createLinkSet();
        this.binsToLinks(binner, linkSet);
        return linkSet;
    }

    private LinkSet findMultiPairMatches(LinkSet possibleLinks, int index0, boolean bestOnly) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        double nLink = possibleLinks.size();
        int iLink = 0;
        this.indicator.startStage("Locating pair matches between " + index0 + " and other tables");
        Iterator it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = (RowLink)it.next();
            it.remove();
            int nref = link.size();
            boolean hasOthers = false;
            for (int iref = 0; iref < nref && !hasOthers; ++iref) {
                if (link.getRef(iref).getTableIndex() == index0) continue;
                hasOthers = true;
            }
            if (hasOthers) {
                Object[][] binnedRows = new Object[nref][];
                for (int iref = 0; iref < nref; ++iref) {
                    RowRef ref = link.getRef(iref);
                    StarTable table = this.tables[ref.getTableIndex()];
                    binnedRows[iref] = table.getRow(ref.getRowIndex());
                }
                for (int i0 = 0; i0 < nref; ++i0) {
                    RowRef ref0 = link.getRef(i0);
                    int iTable0 = ref0.getTableIndex();
                    if (iTable0 != index0) continue;
                    long irow0 = ref0.getRowIndex();
                    for (int i1 = 0; i1 < nref; ++i1) {
                        double score;
                        RowLink2 pair;
                        RowRef ref1 = link.getRef(i1);
                        int iTable1 = ref1.getTableIndex();
                        if (iTable1 == index0 || pairs.containsLink(pair = new RowLink2(ref0, ref1)) || !((score = this.engine.matchScore(binnedRows[i0], binnedRows[i1])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            this.indicator.setLevel((double)(++iLink) / nLink);
        }
        this.indicator.endStage();
        ObjectBinner pairBinner = Binners.createObjectBinner();
        Iterator it2 = pairs.iterator();
        while (it2.hasNext()) {
            RowRef ref1;
            RowRef ref0;
            RowLink2 pair = (RowLink2)it2.next();
            it2.remove();
            RowRef refA = pair.getRef(0);
            RowRef refB = pair.getRef(1);
            if (refA.getTableIndex() == index0) {
                assert (refB.getTableIndex() != index0);
                ref0 = refA;
                ref1 = refB;
            } else if (refB.getTableIndex() == index0) {
                assert (refA.getTableIndex() != index0);
                ref0 = refB;
                ref1 = refA;
            } else {
                throw new IllegalArgumentException("Pair doesn't contain reference table");
            }
            RowRef key = ref0;
            ScoredRef value = new ScoredRef(ref1, pair.getScore());
            pairBinner.addItem(key, value);
        }
        LinkSet multiLinks = this.createLinkSet();
        Iterator it3 = pairBinner.getKeyIterator();
        while (it3.hasNext()) {
            RowRef ref0 = (RowRef)it3.next();
            ScoredRef[] sref1s = pairBinner.getList(ref0).toArray(new ScoredRef[0]);
            int nref1 = sref1s.length;
            if (nref1 <= 0) continue;
            RowRef[] ref1s = new RowRef[nref1];
            double[] scores = new double[nref1];
            for (int ir1 = 0; ir1 < nref1; ++ir1) {
                ref1s[ir1] = sref1s[ir1].ref_;
                scores[ir1] = sref1s[ir1].score_;
            }
            multiLinks.addLink(new PairsRowLink(ref0, ref1s, scores, bestOnly));
        }
        return multiLinks;
    }

    private boolean acceptRow(RowLink link, MultiJoinType[] joinTypes) {
        boolean[] present = new boolean[this.nTable];
        int nref = link.size();
        for (int i = 0; i < nref; ++i) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            present[iTable] = true;
        }
        return MultiJoinType.accept(joinTypes, present);
    }

    LinkSet eliminateMultipleRowEntries(LinkSet pairs) throws InterruptedException {
        Collection inPairs = this.toSortedList(pairs, new Comparator(){

            public int compare(Object o1, Object o2) {
                double score2;
                RowLink2 r1 = (RowLink2)o1;
                RowLink2 r2 = (RowLink2)o2;
                double score1 = r1.getScore();
                if (score1 < (score2 = r2.getScore())) {
                    return -1;
                }
                if (score1 > score2) {
                    return 1;
                }
                return r1.compareTo(r2);
            }
        });
        pairs = null;
        LinkSet outPairs = this.createLinkSet();
        HashSet<RowRef> seenRows = new HashSet<RowRef>();
        double nPair = inPairs.size();
        int iPair = 0;
        this.indicator.startStage("Eliminating multiple row references");
        for (RowLink2 pair : inPairs) {
            boolean seen2;
            double score = pair.getScore();
            if (pair.size() != 2 || Double.isNaN(score) || score < 0.0) {
                throw new IllegalArgumentException();
            }
            RowRef ref1 = pair.getRef(0);
            RowRef ref2 = pair.getRef(1);
            if (ref1.getTableIndex() != 0 || ref2.getTableIndex() != 1) {
                throw new IllegalArgumentException();
            }
            boolean seen1 = !seenRows.add(ref1);
            boolean bl = seen2 = !seenRows.add(ref2);
            if (!seen1 && !seen2) {
                outPairs.addLink(pair);
            }
            this.indicator.setLevel((double)(++iPair) / nPair);
        }
        this.indicator.endStage();
        return outPairs;
    }

    private LinkSet agglomerateLinks(LinkSet links) throws InterruptedException {
        ObjectBinner refBinner = Binners.createModifiableObjectBinner();
        this.indicator.startStage("Mapping rows to links");
        double nlink1 = links.size();
        int ilink1 = 0;
        Iterator linkIt = links.iterator();
        while (linkIt.hasNext()) {
            this.indicator.setLevel((double)(++ilink1) / nlink1);
            RowLink link = (RowLink)linkIt.next();
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                refBinner.addItem(ref, link);
            }
        }
        this.indicator.endStage();
        LinkSet agglomeratedLinks = this.createLinkSet();
        this.indicator.startStage("Identifying isolated links");
        double nlink2 = links.size();
        int ilink2 = 0;
        Iterator it = links.iterator();
        while (it.hasNext()) {
            RowRef ref;
            int i;
            this.indicator.setLevel((double)(++ilink2) / nlink2);
            RowLink link = (RowLink)it.next();
            int nref = link.size();
            boolean isolated = true;
            for (i = 0; isolated && i < nref; ++i) {
                ref = link.getRef(i);
                List refLinks = refBinner.getList(ref);
                assert (refLinks.size() > 0);
                isolated = isolated && refLinks.size() == 1;
            }
            if (!isolated) continue;
            assert (!agglomeratedLinks.containsLink(link));
            agglomeratedLinks.addLink(link);
            for (i = 0; i < nref; ++i) {
                ref = link.getRef(i);
                refBinner.remove(ref);
            }
        }
        this.indicator.endStage();
        double nRefs = refBinner.getBinCount();
        this.indicator.startStage("Walking links");
        while (refBinner.getBinCount() > 0L) {
            this.indicator.setLevel(1.0 - (double)refBinner.getBinCount() / nRefs);
            RowRef ref1 = (RowRef)refBinner.getKeyIterator().next();
            HashSet refSet = new HashSet();
            RowMatcher.walkLinks(ref1, refBinner, refSet);
            RowLink link = new RowLink(refSet);
            assert (!agglomeratedLinks.containsLink(link));
            agglomeratedLinks.addLink(new RowLink(refSet));
        }
        this.indicator.endStage();
        return agglomeratedLinks;
    }

    int getPairColumnCount(int index1, int index2) {
        int ncol = this.tables[index1].getColumnCount();
        if (this.tables[index2].getColumnCount() != ncol) {
            throw new IllegalArgumentException("Column count mismatch");
        }
        return ncol;
    }

    private static void walkLinks(RowRef baseRef, ObjectBinner refBinner, Set outSet) {
        if (!outSet.contains(baseRef)) {
            List links = refBinner.getList(baseRef);
            if (!links.isEmpty()) {
                outSet.add(baseRef);
                Iterator linkIt = links.iterator();
                while (linkIt.hasNext()) {
                    RowLink link = (RowLink)linkIt.next();
                    for (int i = 0; i < link.size(); ++i) {
                        RowRef rref = link.getRef(i);
                        RowMatcher.walkLinks(rref, refBinner, outSet);
                    }
                    linkIt.remove();
                }
            }
            if (links.isEmpty()) {
                refBinner.remove(baseRef);
            }
        }
    }

    private void checkRandom() {
        for (int itab = 0; itab < this.tables.length; ++itab) {
            if (this.tables[itab].isRandom()) continue;
            throw new IllegalArgumentException("Table " + this.tables[itab] + " is not random access");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NdRange readTupleRange(int tIndex) throws IOException, InterruptedException {
        StarTable table = this.tables[tIndex];
        int ncol = table.getColumnCount();
        boolean[] isComparable = new boolean[ncol];
        int ncomp = 0;
        for (int icol = 0; icol < ncol; ++icol) {
            if (!Comparable.class.isAssignableFrom(table.getColumnInfo(icol).getContentClass())) continue;
            isComparable[icol] = true;
            ++ncomp;
        }
        if (ncomp == 0) {
            return new NdRange(ncol);
        }
        Comparable[] mins = new Comparable[ncol];
        Comparable[] maxs = new Comparable[ncol];
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Assessing range of coordinates from table " + (tIndex + 1));
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    Object cell;
                    if (!isComparable[icol] || !((cell = row[icol]) instanceof Comparable) || Tables.isBlank(cell)) continue;
                    Comparable val = (Comparable)cell;
                    mins[icol] = NdRange.min(mins[icol], val, false);
                    maxs[icol] = NdRange.max(maxs[icol], val, false);
                }
                ++lrow;
            }
        }
        finally {
            rseq.close();
        }
        for (int icol = 0; icol < ncol; ++icol) {
            if (mins[icol] instanceof Number) {
                double min = ((Number)((Object)mins[icol])).doubleValue();
                assert (!Double.isNaN(min));
                if (Double.isInfinite(min)) {
                    mins[icol] = null;
                }
            }
            if (!(maxs[icol] instanceof Number)) continue;
            double max = ((Number)((Object)maxs[icol])).doubleValue();
            assert (!Double.isNaN(max));
            if (!Double.isInfinite(max)) continue;
            maxs[icol] = null;
        }
        NdRange range = new NdRange(mins, maxs);
        this.indicator.logMessage("Limits are: " + range);
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void binRows(int itab, NdRange range, ObjectBinner binner, boolean newBins) throws IOException, InterruptedException {
        if (range == null) {
            return;
        }
        StarTable table = this.tables[itab];
        ProgressRowSequence rseq = new ProgressRowSequence(table, this.indicator, "Binning rows for table " + (itab + 1));
        long nrow = 0L;
        long nexclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                Object[] row = rseq.getRow();
                if (range.isInside(row)) {
                    Object[] keys = this.engine.getBins(row);
                    int nkey = keys.length;
                    if (nkey > 0) {
                        RowRef rref = new RowRef(itab, lrow);
                        for (int ikey = 0; ikey < nkey; ++ikey) {
                            Object key = keys[ikey];
                            if (!newBins && !binner.containsKey(key)) continue;
                            binner.addItem(key, rref);
                        }
                    }
                } else {
                    ++nexclude;
                }
                ++nrow;
                ++lrow;
            }
            assert (nrow == table.getRowCount());
        }
        finally {
            rseq.close();
        }
        if (nexclude > 0L) {
            this.indicator.logMessage(nexclude + "/" + nrow + " rows excluded " + "(out of match region)");
        }
    }

    private void binsToLinks(ObjectBinner binner, LinkSet linkSet) throws InterruptedException {
        long nrow = binner.getItemCount();
        long nbin = binner.getBinCount();
        this.indicator.logMessage(nrow + " row refs in " + nbin + " bins");
        this.indicator.logMessage("(average bin occupancy " + (float)nrow / (float)nbin + ")");
        this.indicator.startStage("Consolidating potential match groups");
        double nl = nbin;
        long il = 0L;
        Iterator it = binner.getKeyIterator();
        while (it.hasNext()) {
            Object key = it.next();
            List refList = binner.getList(key);
            if (refList.size() > 1) {
                linkSet.addLink(new RowLink(refList));
            }
            it.remove();
            this.indicator.setLevel((double)(++il) / nl);
        }
        assert (binner.getBinCount() == 0L);
        this.indicator.endStage();
    }

    private void binsToInternalLinks(LongBinner binner, LinkSet linkSet, int itable) throws InterruptedException {
        long nbin = binner.getBinCount();
        this.indicator.startStage("Consolidating potential match groups");
        double nl = nbin;
        long il = 0L;
        Iterator it = binner.getKeyIterator();
        while (it.hasNext()) {
            Object key = it.next();
            long[] irs = binner.getLongs(key);
            int nir = irs.length;
            if (nir > 1) {
                RowRef[] refs = new RowRef[nir];
                for (int iir = 0; iir < nir; ++iir) {
                    refs[iir] = new RowRef(itable, irs[iir]);
                }
                linkSet.addLink(new RowLink(refs));
            }
            it.remove();
            this.indicator.setLevel((double)(++il) / nl);
        }
        assert (binner.getBinCount() == 0L);
        this.indicator.endStage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long countInRange(int tIndex, NdRange range) throws IOException, InterruptedException {
        ProgressRowSequence rseq = new ProgressRowSequence(this.tables[tIndex], this.indicator, "Counting rows in match region for table " + (tIndex + 1));
        long nInclude = 0L;
        try {
            long lrow = 0L;
            while (rseq.nextProgress()) {
                if (range.isInside(rseq.getRow())) {
                    ++nInclude;
                }
                ++lrow;
            }
        }
        finally {
            rseq.close();
        }
        this.indicator.logMessage(nInclude + " rows in match region");
        return nInclude;
    }

    private Collection toSortedList(LinkSet linkSet, Comparator comparator) {
        int nLink = linkSet.size();
        RowLink[] links = new RowLink[nLink];
        int il = 0;
        Iterator it = linkSet.iterator();
        while (it.hasNext()) {
            links[il++] = (RowLink)it.next();
        }
        Arrays.sort(links, comparator);
        return Arrays.asList(links);
    }

    private void startMatch() {
        this.startTime = new Date().getTime();
        this.indicator.logMessage("Params:" + RowMatcher.formatParams(this.engine.getMatchParameters()));
        this.indicator.logMessage("Tuning:" + RowMatcher.formatParams(this.engine.getTuningParameters()));
    }

    private static String formatParams(DescribedValue[] params) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            sbuf.append(i == 0 ? " " : ", ").append(params[i]);
        }
        return sbuf.toString();
    }

    private void endMatch() {
        long millis = new Date().getTime() - this.startTime;
        this.indicator.logMessage("Elapsed time for match: " + millis / 1000L + " seconds");
    }

    private static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    private static class Intersection {
        final NdRange range_;
        final long[] inRangeCounts_;

        public Intersection(NdRange range, long[] inRangeCounts) {
            this.range_ = range;
            this.inRangeCounts_ = inRangeCounts;
        }
    }

    private static class ScoredRef {
        final RowRef ref_;
        final double score_;

        public ScoredRef(RowRef ref, double score) {
            this.ref_ = ref;
            this.score_ = score;
        }
    }
}

