/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class SphericalPolarMatchEngine
extends AbstractCartesianMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERR_INFO)};
    private static final DefaultValueInfo R_INFO = new DefaultValueInfo("Distance", Number.class, "Distance from origin");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Cartesian distance between matched points");
    private static final DefaultValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Maximum Cartesian separation for match");

    public SphericalPolarMatchEngine(double err) {
        super(3);
        this.setIsotropicScale(err);
    }

    public void setError(double err) {
        this.setIsotropicScale(err);
    }

    public double getError() {
        return this.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO, R_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return SphericalPolarMatchEngine.matchScore(3, SphericalPolarMatchEngine.toXyz(tuple1), SphericalPolarMatchEngine.toXyz(tuple2), this.getError());
    }

    @Override
    public double getScoreScale() {
        return this.getError();
    }

    @Override
    public Object[] getBins(Object[] tuple) {
        return this.getRadiusBins(SphericalPolarMatchEngine.toXyz(tuple), this.getError() * 0.5);
    }

    @Override
    public boolean canBoundMatch() {
        return false;
    }

    @Override
    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "Sky 3D";
    }

    private static double[] toXyz(Object[] tuple) {
        double ra = SphericalPolarMatchEngine.getNumberValue(tuple[0]);
        double dec = SphericalPolarMatchEngine.getNumberValue(tuple[1]);
        double r = SphericalPolarMatchEngine.getNumberValue(tuple[2]);
        double cd = Math.cos(dec);
        double sd = Math.sin(dec);
        double cr = Math.cos(ra);
        double sr = Math.sin(ra);
        double x = r * cr * cd;
        double y = r * sr * cd;
        double z = r * sd;
        return new double[]{x, y, z};
    }

    static {
        ERR_INFO.setUnitString("units of distance");
    }
}

