/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.PrintStream;
import uk.ac.starlink.table.join.Profiler;
import uk.ac.starlink.table.join.ProgressIndicator;

public class TextProgressIndicator
implements ProgressIndicator {
    int dotCount;
    final int fullWidth = 78;
    int blankWidth;
    PrintStream out = System.out;
    final Profiler profiler;
    long lastUsedMem;

    public TextProgressIndicator(PrintStream out, boolean profile) {
        this.out = out;
        this.profiler = profile ? new Profiler() : null;
    }

    @Override
    public void startStage(String stage) {
        this.out.print(stage);
        this.blankWidth = 78 - stage.length();
        this.dotCount = 0;
        if (this.profiler != null) {
            this.profiler.reset();
        }
    }

    @Override
    public void setLevel(double level) {
        assert (level >= 0.0 && level <= 1.0);
        level = Math.max(Math.min(level, 1.0), 0.0);
        int moreDots = (int)(level * (double)this.blankWidth) - this.dotCount;
        for (int i = 0; i < moreDots; ++i) {
            this.out.print(".");
            ++this.dotCount;
        }
    }

    @Override
    public void endStage() {
        this.out.println();
        if (this.profiler != null) {
            this.logMessage(this.profiler.report());
        }
    }

    @Override
    public void logMessage(String msg) {
        this.out.println(msg);
    }
}

