/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.lang.reflect.Array;
import uk.ac.starlink.table.ValueStore;

public class ArrayPrimitiveStore
implements ValueStore {
    private final Class clazz_;
    private final Object data_;
    private final long size_;

    public ArrayPrimitiveStore(Class clazz, int size) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " not primitive");
        }
        this.clazz_ = clazz;
        this.size_ = size;
        this.data_ = Array.newInstance(clazz, size);
    }

    @Override
    public Class getType() {
        return this.clazz_;
    }

    @Override
    public long getLength() {
        return this.size_;
    }

    @Override
    public void put(long index, Object array, int ioff, int count) {
        if (index >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of range");
        }
        System.arraycopy(array, ioff, this.data_, (int)index, count);
    }

    @Override
    public void get(long index, Object array, int ioff, int count) {
        if (index >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of range");
        }
        System.arraycopy(this.data_, (int)index, array, ioff, count);
    }
}

