/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnWidth;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.table.storage.Offsets;
import uk.ac.starlink.util.IntList;

public class ByteStoreRowStore
implements RowStore {
    private final ByteStore byteStore_;
    private final DataOutputStream out_;
    private int ncol_;
    private int nrow_;
    private Codec[] codecs_;
    private IntList[] colSizeLists_;
    private Offsets offsets_;
    private StarTable template_;
    private StarTable storedTable_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public ByteStoreRowStore(ByteStore byteStore) {
        this.byteStore_ = byteStore;
        this.out_ = new DataOutputStream(new BufferedOutputStream(byteStore.getOutputStream()));
    }

    public ByteStore getByteStore() {
        return this.byteStore_;
    }

    @Override
    public void acceptMetadata(StarTable meta) throws TableFormatException {
        if (this.template_ != null) {
            throw new IllegalStateException("Metadata already submitted");
        }
        this.template_ = meta;
        this.ncol_ = meta.getColumnCount();
        this.codecs_ = new Codec[this.ncol_];
        this.colSizeLists_ = new IntList[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo cinfo = meta.getColumnInfo(icol);
            Codec codec = Codec.getCodec(cinfo);
            if (codec == null) {
                throw new TableFormatException("No codec available for " + cinfo);
            }
            this.codecs_[icol] = codec;
            if (codec.getItemSize() >= 0) continue;
            this.colSizeLists_[icol] = new IntList();
        }
    }

    @Override
    public void acceptRow(Object[] row) throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            int nbyte = this.codecs_[icol].encode(row[icol], this.out_);
            if (this.colSizeLists_[icol] == null) continue;
            this.colSizeLists_[icol].add(nbyte);
        }
        ++this.nrow_;
    }

    @Override
    public void endRows() throws IOException {
        if (this.template_ == null) {
            throw new IllegalStateException("acceptMetadata not called");
        }
        if (this.storedTable_ != null) {
            throw new IllegalStateException("endRows already called");
        }
        this.out_.close();
        ColumnWidth[] colWidths = new ColumnWidth[this.ncol_];
        boolean someVariable = false;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnWidth cw;
            if (this.colSizeLists_[icol] == null) {
                cw = ColumnWidth.constantColumnWidth(this.codecs_[icol].getItemSize());
            } else {
                cw = ColumnWidth.variableColumnWidth(this.colSizeLists_[icol].toIntArray());
                this.colSizeLists_[icol] = null;
            }
            colWidths[icol] = cw;
        }
        this.colSizeLists_ = null;
        this.offsets_ = Offsets.getOffsets(colWidths, this.nrow_);
        logger_.config("Offset type is " + (this.offsets_.isFixed() ? "fixed" : "variable"));
        ByteBuffer[] bbufs = this.byteStore_.toByteBuffers();
        long nbyte = 0L;
        for (int ib = 0; ib < bbufs.length; ++ib) {
            nbyte += (long)bbufs[ib].limit();
        }
        logger_.config(this.nrow_ + " rows stored in " + nbyte + " bytes");
        ByteStoreAccess access = NioByteStoreAccess.createAccess(bbufs);
        this.storedTable_ = new ByteStoreStarTable(this.template_, this.nrow_, this.codecs_, this.offsets_, access);
    }

    @Override
    public StarTable getStarTable() {
        if (this.storedTable_ == null) {
            throw new IllegalStateException("endRows not called");
        }
        return this.storedTable_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.byteStore_.close();
        }
        finally {
            super.finalize();
        }
    }

    Offsets getOffsets() {
        return this.offsets_;
    }

    private static class ByteStoreStarTable
    extends WrapperStarTable {
        private final ByteStoreAccess access_;
        private final long nrow_;
        private final int ncol_;
        private final Codec[] codecs_;
        private final Offsets offsets_;

        ByteStoreStarTable(StarTable template, long nrow, Codec[] codecs, Offsets offsets, ByteStoreAccess access) {
            super(template);
            this.nrow_ = nrow;
            this.ncol_ = template.getColumnCount();
            this.codecs_ = codecs;
            this.offsets_ = offsets;
            this.access_ = access;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public long getRowCount() {
            return this.nrow_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getRow(long lrow) throws IOException {
            Object[] row = new Object[this.ncol_];
            ByteStoreAccess byteStoreAccess = this.access_;
            synchronized (byteStoreAccess) {
                this.access_.seek(this.offsets_.getRowOffset(lrow));
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    row[icol] = this.codecs_[icol].decode(this.access_);
                }
            }
            return row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            Object cell;
            ByteStoreAccess byteStoreAccess = this.access_;
            synchronized (byteStoreAccess) {
                this.access_.seek(this.offsets_.getCellOffset(lrow, icol));
                cell = this.codecs_[icol].decode(this.access_);
            }
            return cell;
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            return new RandomRowSequence(this);
        }
    }
}

