/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.storage.ByteStoreRowStore;
import uk.ac.starlink.table.storage.ListRowStore;
import uk.ac.starlink.table.storage.MemoryByteStore;

public abstract class ByteStoreStoragePolicy
extends StoragePolicy {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    protected abstract ByteStore attemptMakeByteStore() throws IOException;

    @Override
    public ByteStore makeByteStore() {
        Throwable error;
        try {
            return this.attemptMakeByteStore();
        }
        catch (IOException e) {
            error = e;
        }
        catch (SecurityException e) {
            error = e;
        }
        catch (OutOfMemoryError e) {
            error = e;
        }
        assert (error != null);
        logger_.warning("Failed to create byte storage: " + error + " - using memory instead");
        return new MemoryByteStore();
    }

    @Override
    public RowStore makeRowStore() {
        return new ByteStoreRowStore(this.makeByteStore());
    }

    @Override
    public RowStore makeConfiguredRowStore(StarTable meta) {
        RowStore store = this.makeRowStore();
        try {
            store.acceptMetadata(meta);
            return store;
        }
        catch (TableFormatException e) {
            logger_.warning("Row store " + store + " unsuitable for table: " + e + " - using memory instead");
            ListRowStore memStore = new ListRowStore();
            memStore.acceptMetadata(meta);
            return memStore;
        }
    }
}

