/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;

public class FileByteStore
implements ByteStore {
    private final File file_;
    private final OutputStream out_;
    private final int maxBufLen_;
    private long length_;
    private final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.storage");

    public FileByteStore(File file) throws IOException {
        this.file_ = file;
        this.out_ = new FileOutputStream(this.file_){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                FileByteStore.this.length_++;
            }

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                FileByteStore.this.length_ += b.length;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                FileByteStore.this.length_ += len;
            }
        };
        this.maxBufLen_ = Integer.MAX_VALUE;
    }

    public FileByteStore() throws IOException {
        this(File.createTempFile("FileByteStore", ".bin"));
        this.file_.deleteOnExit();
        this.logger_.info("Creating new temporary file: " + this.file_);
    }

    public File getFile() {
        return this.file_;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out_;
    }

    @Override
    public long getLength() {
        return this.length_;
    }

    @Override
    public void copy(OutputStream out) throws IOException {
        this.out_.flush();
        FileByteStore.copy(this.file_, out);
    }

    @Override
    public ByteBuffer[] toByteBuffers() throws IOException {
        this.out_.flush();
        return FileByteStore.toByteBuffers(this.file_, this.maxBufLen_);
    }

    static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        long size = file.length();
        FileChannel inChannel = in.getChannel();
        WritableByteChannel outChannel = out instanceof FileOutputStream ? ((FileOutputStream)out).getChannel() : Channels.newChannel(out);
        long count = inChannel.transferTo(0L, size, outChannel);
        in.close();
        if (count < size) {
            throw new IOException("Only " + count + "/" + size + " bytes could be transferred");
        }
    }

    static ByteBuffer[] toByteBuffers(File file, int maxLen) throws IOException {
        long size = file.length();
        if (size == 0L) {
            return new ByteBuffer[]{ByteBuffer.allocate(0)};
        }
        FileInputStream in = new FileInputStream(file);
        FileChannel chan = in.getChannel();
        FileChannel.MapMode mode = FileChannel.MapMode.READ_ONLY;
        long mBuf = (size - 1L) / (long)maxLen + 1L;
        int nBuf = (int)mBuf;
        if ((long)nBuf != mBuf) {
            throw new IOException("HOW big???");
        }
        ByteBuffer[] bufs = new ByteBuffer[nBuf];
        for (int ib = 0; ib < nBuf; ++ib) {
            long start = (long)ib * (long)maxLen;
            assert (size >= 0L);
            assert (size - start > 0L);
            long len = Math.min(size - start, (long)maxLen);
            bufs[ib] = chan.map(mode, start, len);
        }
        in.close();
        return bufs;
    }

    @Override
    public void close() {
        try {
            this.out_.close();
        }
        catch (IOException e) {
            this.logger_.warning("close error: " + e);
        }
        if (this.file_.delete()) {
            this.logger_.info("Deleting temporary file: " + this.file_);
        } else if (this.file_.exists()) {
            this.logger_.warning("Failed to delete temporary file " + this.file_);
        } else {
            this.logger_.info("Temporary file got deleted before close");
        }
    }
}

