/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.SingleNioAccess;

class IndexedMappedColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final RandomAccessFile auxRaf_;
    private final LongBuffer indexBuf_;
    private long auxOffset_;
    private long nrow_;
    private ByteStoreAccess auxAccess_;

    public IndexedMappedColumnStore(Codec codec, ByteBuffer bbuf, File auxFile) throws IOException {
        this.codec_ = codec;
        this.indexBuf_ = bbuf.asLongBuffer();
        this.auxRaf_ = new RandomAccessFile(auxFile, "rw");
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        this.indexBuf_.put(this.auxOffset_);
        this.auxOffset_ += (long)this.codec_.encode(value, this.auxRaf_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        MappedByteBuffer auxBuf = this.auxRaf_.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.auxOffset_);
        this.auxAccess_ = new SingleNioAccess(auxBuf);
        this.auxRaf_.close();
    }

    @Override
    public synchronized Object readCell(long lrow) throws IOException {
        this.auxAccess_.seek(this.indexBuf_.get(Tables.checkedLongToInt(lrow)));
        return this.codec_.decode(this.auxAccess_);
    }

    @Override
    public void dispose() {
        try {
            this.auxRaf_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

