/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.SingleNioAccess;

class IndexedStreamColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final File dataFile_;
    private final File indexFile_;
    private final DataOutputStream dataOut_;
    private final DataOutputStream indexOut_;
    private long dataOffset_;
    private long nrow_;
    private ByteStoreAccess dataIn_;
    private LongBuffer indexIn_;

    public IndexedStreamColumnStore(Codec codec, File dataFile, File indexFile) throws IOException {
        this.codec_ = codec;
        this.dataFile_ = dataFile;
        this.indexFile_ = indexFile;
        this.dataOut_ = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
        this.indexOut_ = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        this.indexOut_.writeLong(this.dataOffset_);
        this.dataOffset_ += (long)this.codec_.encode(value, this.dataOut_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        this.dataOut_.close();
        this.indexOut_.close();
        MappedByteBuffer dataBuf = new RandomAccessFile(this.dataFile_, "r").getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.dataOffset_);
        this.dataIn_ = new SingleNioAccess(dataBuf);
        MappedByteBuffer indexBuf = new RandomAccessFile(this.indexFile_, "r").getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 8L * this.nrow_);
        this.indexIn_ = indexBuf.asLongBuffer();
    }

    @Override
    public synchronized Object readCell(long lrow) throws IOException {
        this.dataIn_.seek(this.indexIn_.get(Tables.checkedLongToInt(lrow)));
        return this.codec_.decode(this.dataIn_);
    }

    @Override
    public void dispose() {
        try {
            this.dataOut_.close();
            this.indexOut_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

