/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.SingleNioAccess;

class StreamColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final File dataFile_;
    private final DataOutputStream dataOut_;
    private final int itemSize_;
    private long nrow_;
    private ByteStoreAccess dataIn_;

    public StreamColumnStore(Codec codec, File dataFile) throws IOException {
        this.codec_ = codec;
        this.dataFile_ = dataFile;
        this.itemSize_ = codec.getItemSize();
        if (this.itemSize_ < 0) {
            throw new IllegalArgumentException("Must have fixed size codec");
        }
        this.dataOut_ = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        int nbyte = this.codec_.encode(value, this.dataOut_);
        assert (nbyte == this.itemSize_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        this.dataOut_.close();
        MappedByteBuffer bbuf = new RandomAccessFile(this.dataFile_, "r").getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, (long)this.itemSize_ * this.nrow_);
        this.dataIn_ = new SingleNioAccess(bbuf);
    }

    @Override
    public synchronized Object readCell(long lrow) throws IOException {
        this.dataIn_.seek(lrow * (long)this.itemSize_);
        return this.codec_.decode(this.dataIn_);
    }

    @Override
    public void dispose() {
        try {
            this.dataOut_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

