/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.Transformer;
import skyview.survey.Image;
import skyview.util.Utilities;

public abstract class Sampler
implements Component,
Cloneable {
    protected Image inImage;
    protected int inHeight;
    protected int inWidth;
    protected int inDepth;
    protected int[] bounds;
    protected Image outImage;
    protected int outHeight;
    protected int outWidth;
    protected int outDepth;
    protected Transformer trans;

    public abstract void sample(int var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setInput(Image inImage) {
        this.inImage = inImage;
        this.inWidth = inImage.getWidth();
        this.inHeight = inImage.getHeight();
        this.inDepth = inImage.getDepth();
    }

    public void setBounds(int[] bounds) {
        this.bounds = bounds;
    }

    public void setOutput(Image outImage) {
        this.outImage = outImage;
        this.outWidth = outImage.getWidth();
        this.outHeight = outImage.getHeight();
        this.outDepth = outImage.getDepth();
    }

    public void setTransform(Transformer transform) {
        this.trans = transform;
    }

    public static Sampler factory(String type) {
        int j;
        String base = null;
        String numb = null;
        for (j = type.length() - 1; j > 1 && type.charAt(j) >= '0' && type.charAt(j) <= '9'; --j) {
        }
        if (j < type.length() - 1) {
            base = type.substring(0, j + 1);
            numb = type.substring(j + 1);
        } else {
            base = type;
        }
        String classString = "skyview.geometry.sampler." + base + "Sampler";
        Sampler samp = (Sampler)Utilities.newInstance((String)base, (String)"skyview.geometry.sampler");
        if (samp == null) {
            throw new Error("Invalid sampler name:" + base);
        }
        if (numb != null) {
            int param = Integer.parseInt(numb);
            samp.setOrder(param);
        }
        return samp;
    }

    public void setOrder(int order) {
    }
}

