/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class Sfl
extends Projecter {
    public String getName() {
        return "Sfl";
    }

    public String getDescription() {
        return "Transform from the celestial sphere to the sinusoidal projection";
    }

    public Deprojecter inverse() {
        return new SflDeproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("SflDeproj");
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[1] = Math.atan2(sphere[2], Math.sqrt(sphere[0] * sphere[0] + sphere[1] * sphere[1]));
            plane[0] = Math.atan2(sphere[1], sphere[0]) * Math.cos(plane[1]);
        }
    }

    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && Math.abs(plane[1]) <= 1.5707963267948966 && Math.abs(plane[0]) <= Math.PI * Math.cos(plane[1]);
    }

    public class SflDeproj
    extends Deprojecter {
        public String getName() {
            return "SflDeproj";
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Sfl");
        }

        public String getDescription() {
            return "Transform from a sinusoidal projection to the corresponding unit vector.";
        }

        public Projecter inverse() {
            return Sfl.this;
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Sfl.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double dec = plane[1];
                double sd = Math.sin(dec);
                double cd = Math.cos(dec);
                if (Math.abs(dec) <= 1.5707963267948966 && Math.abs(plane[0]) <= Math.PI * cd) {
                    double ra = plane[0];
                    if (cd > 0.0) {
                        ra /= cd;
                    }
                    double sr = Math.sin(ra);
                    double cr = Math.cos(ra);
                    sphere[0] = cr * cd;
                    sphere[1] = sr * cd;
                    sphere[2] = sd;
                }
            }
        }
    }
}

