/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import uk.ac.starlink.votable.Decoder;

abstract class CharDecoders {
    CharDecoders() {
    }

    public static Decoder makeCharDecoder(long[] arraysize) {
        CharReader cread = new CharReader(){

            @Override
            public char readCharFromStream(DataInput strm) throws IOException {
                return (char)(strm.readByte() & 0xFF);
            }

            @Override
            public int getCharSize() {
                return 1;
            }
        };
        return CharDecoders.makeDecoder(arraysize, cread);
    }

    public static Decoder makeUnicodeCharDecoder(long[] arraysize) {
        CharReader cread = new CharReader(){

            @Override
            public char readCharFromStream(DataInput strm) throws IOException {
                return strm.readChar();
            }

            @Override
            public int getCharSize() {
                return 2;
            }
        };
        return CharDecoders.makeDecoder(arraysize, cread);
    }

    private static Decoder makeDecoder(long[] arraysize, CharReader cread) {
        int ndim = arraysize.length;
        if (ndim == 0 || ndim == 1 && arraysize[0] == 1L) {
            return new ScalarCharDecoder(cread);
        }
        if (ndim == 1 && arraysize[0] == -2L) {
            return new ScalarStringDecoder(arraysize, cread){

                @Override
                public Object decodeStream(DataInput strm) throws IOException {
                    throw new RuntimeException("Refuse to decode assumed char arraysize - try -Dvotable.strict=true");
                }

                @Override
                public void skipStream(DataInput strm) throws IOException {
                    this.decodeStream(strm);
                }
            };
        }
        if (ndim == 1) {
            return new ScalarStringDecoder(arraysize, cread);
        }
        return new StringDecoder(arraysize, cread);
    }

    private static class StringDecoder
    extends Decoder {
        final CharReader cread;
        final long[] decodedShape;
        final boolean isVariable;
        int fixedSize;

        StringDecoder(long[] arraysize, CharReader cread) {
            super(String[].class, arraysize);
            this.cread = cread;
            int ndim = arraysize.length;
            this.decodedShape = new long[ndim - 1];
            System.arraycopy(arraysize, 1, this.decodedShape, 0, ndim - 1);
            boolean bl = this.isVariable = arraysize[ndim - 1] < 0L;
            if (!this.isVariable) {
                this.fixedSize = 1;
                for (int i = 0; i < arraysize.length; ++i) {
                    this.fixedSize = (int)((long)this.fixedSize * arraysize[i]);
                }
            }
        }

        @Override
        public long[] getDecodedShape() {
            return this.decodedShape;
        }

        @Override
        public int getElementSize() {
            return (int)this.arraysize[0];
        }

        @Override
        public int getNumItems(DataInput strm) throws IOException {
            return this.isVariable ? super.getNumItems(strm) : this.fixedSize;
        }

        @Override
        public Object decodeString(String txt) {
            return this.makeStrings(txt);
        }

        @Override
        public Object decodeStream(DataInput strm) throws IOException {
            int num = this.getNumItems(strm);
            StringBuffer sbuf = new StringBuffer(num);
            for (int i = 0; i < num; ++i) {
                sbuf.append(this.cread.readCharFromStream(strm));
            }
            return this.makeStrings(sbuf);
        }

        @Override
        public void skipStream(DataInput strm) throws IOException {
            int num = this.getNumItems(strm);
            StringDecoder.skipBytes(strm, this.cread.getCharSize() * num);
        }

        public String[] makeStrings(CharSequence txt) {
            int ntok = txt.length();
            int ncell = this.numCells(ntok);
            int sleng = (int)this.arraysize[0];
            int nstr = ncell / sleng;
            String[] result = new String[nstr];
            int k = 0;
            char[] buf = new char[sleng];
            for (int i = 0; i < nstr && k < ntok; ++i) {
                char c;
                int leng = 0;
                while (leng < sleng && k < ntok && (c = txt.charAt(k++)) != '\u0000') {
                    buf[leng++] = c;
                }
                while (leng > 0 && buf[leng - 1] == ' ') {
                    --leng;
                }
                if (leng > 0) {
                    result[i] = new String(buf, 0, leng);
                }
                k = (i + 1) * sleng;
            }
            return result;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return false;
        }

        @Override
        public void setNullValue(String txt) {
        }
    }

    private static class ScalarStringDecoder
    extends Decoder {
        final CharReader cread;

        ScalarStringDecoder(long[] arraysize, CharReader cread) {
            super(String.class, arraysize);
            this.cread = cread;
        }

        @Override
        public long[] getDecodedShape() {
            return SCALAR_SIZE;
        }

        @Override
        public int getElementSize() {
            return (int)this.arraysize[0];
        }

        @Override
        public Object decodeString(String txt) {
            return txt;
        }

        @Override
        public Object decodeStream(DataInput strm) throws IOException {
            int i;
            int num = this.getNumItems(strm);
            StringBuffer data = new StringBuffer(num);
            for (i = 0; i < num; ++i) {
                char c = this.cread.readCharFromStream(strm);
                if (c == '\u0000') break;
                data.append(c);
            }
            while (i < num) {
                this.cread.readCharFromStream(strm);
                ++i;
            }
            return new String(data);
        }

        @Override
        public void skipStream(DataInput strm) throws IOException {
            int num = this.getNumItems(strm);
            ScalarStringDecoder.skipBytes(strm, num * this.cread.getCharSize());
        }

        String makeString(CharSequence txt) {
            char c;
            int leng = 0;
            int sleng = txt.length();
            char[] buf = new char[sleng];
            for (int i = 0; i < sleng && (c = txt.charAt(i)) != '\u0000'; ++i) {
                buf[leng++] = c;
            }
            while (leng > 0 && buf[leng - 1] == ' ') {
                --leng;
            }
            return leng > 0 ? new String(buf, 0, leng) : null;
        }

        @Override
        public boolean isNull(Object array, int index) {
            return false;
        }

        @Override
        public void setNullValue(String txt) {
        }
    }

    private static class ScalarCharDecoder
    extends Decoder {
        final CharReader cread;

        ScalarCharDecoder(CharReader cread) {
            super(Character.class, SCALAR_SIZE);
            this.cread = cread;
        }

        @Override
        public Object decodeString(String txt) {
            return new Character(txt.length() > 0 ? txt.charAt(0) : (char)'\u0000');
        }

        @Override
        public Object decodeStream(DataInput strm) throws IOException {
            assert (this.getNumItems(strm) == 1);
            return new Character(this.cread.readCharFromStream(strm));
        }

        @Override
        public void skipStream(DataInput strm) throws IOException {
            assert (this.getNumItems(strm) == 1);
            ScalarCharDecoder.skipBytes(strm, this.cread.getCharSize());
        }

        @Override
        public boolean isNull(Object array, int index) {
            return false;
        }

        @Override
        public void setNullValue(String txt) {
        }
    }

    private static interface CharReader {
        public char readCharFromStream(DataInput var1) throws IOException;

        public int getCharSize();
    }
}

