/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataInput;
import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.BitDecoder;
import uk.ac.starlink.votable.BooleanDecoder;
import uk.ac.starlink.votable.CharDecoders;
import uk.ac.starlink.votable.DoubleDecoder;
import uk.ac.starlink.votable.FloatDecoder;
import uk.ac.starlink.votable.IntDecoder;
import uk.ac.starlink.votable.LongDecoder;
import uk.ac.starlink.votable.ScalarBitDecoder;
import uk.ac.starlink.votable.ScalarBooleanDecoder;
import uk.ac.starlink.votable.ScalarDoubleDecoder;
import uk.ac.starlink.votable.ScalarFloatDecoder;
import uk.ac.starlink.votable.ScalarIntDecoder;
import uk.ac.starlink.votable.ScalarLongDecoder;
import uk.ac.starlink.votable.ScalarShortDecoder;
import uk.ac.starlink.votable.ScalarUnsignedByteDecoder;
import uk.ac.starlink.votable.ShortDecoder;
import uk.ac.starlink.votable.UnsignedByteDecoder;

abstract class Decoder {
    static Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static final long[] SCALAR_SIZE = new long[0];
    protected String blankString;
    protected boolean isVariable;
    protected int sliceSize;
    protected long[] arraysize;
    private final Class clazz;

    abstract void setNullValue(String var1);

    public abstract Object decodeString(String var1);

    public abstract Object decodeStream(DataInput var1) throws IOException;

    public abstract void skipStream(DataInput var1) throws IOException;

    public abstract boolean isNull(Object var1, int var2);

    protected Decoder(Class clazz, long[] arraysize) {
        this.clazz = clazz;
        this.arraysize = arraysize;
        int ndim = arraysize.length;
        if (ndim == 0) {
            this.isVariable = false;
            this.sliceSize = 1;
        } else if (arraysize[ndim - 1] < 0L) {
            this.isVariable = true;
            long ss = 1L;
            for (int i = 0; i < ndim - 1; ++i) {
                ss *= arraysize[i];
            }
            this.sliceSize = (int)ss;
        } else {
            this.isVariable = false;
            long ss = 1L;
            for (int i = 0; i < ndim; ++i) {
                ss *= arraysize[i];
            }
            this.sliceSize = (int)ss;
        }
    }

    public Class getContentClass() {
        return this.clazz;
    }

    int numCells(int ntok) {
        if (this.isVariable) {
            return (ntok + this.sliceSize - 1) / this.sliceSize * this.sliceSize;
        }
        return this.sliceSize;
    }

    int getNumItems(DataInput strm) throws IOException {
        return this.isVariable ? strm.readInt() : this.sliceSize;
    }

    public long[] getDecodedShape() {
        return this.arraysize;
    }

    public int getElementSize() {
        return -1;
    }

    static void skipBytes(DataInput strm, long num) throws IOException {
        IOUtils.skipBytes(strm, num);
    }

    public static Decoder makeDecoder(String datatype, long[] arraysize, String blank) {
        Decoder dec;
        boolean isScalar;
        int ndim = arraysize.length;
        if (ndim == 0) {
            isScalar = true;
        } else if (arraysize[ndim - 1] > 0L) {
            int nel = 1;
            for (int i = 0; i < ndim; ++i) {
                nel = (int)((long)nel * arraysize[i]);
            }
            isScalar = nel == 1;
        } else {
            isScalar = false;
        }
        if (datatype.equals("boolean")) {
            dec = isScalar ? new ScalarBooleanDecoder() : new BooleanDecoder(arraysize);
        } else if (datatype.equals("bit")) {
            dec = isScalar ? new ScalarBitDecoder() : new BitDecoder(arraysize);
        } else if (datatype.equals("unsignedByte")) {
            dec = isScalar ? new ScalarUnsignedByteDecoder() : new UnsignedByteDecoder(arraysize);
        } else if (datatype.equals("short")) {
            dec = isScalar ? new ScalarShortDecoder() : new ShortDecoder(arraysize);
        } else if (datatype.equals("int")) {
            dec = isScalar ? new ScalarIntDecoder() : new IntDecoder(arraysize);
        } else if (datatype.equals("long")) {
            dec = isScalar ? new ScalarLongDecoder() : new LongDecoder(arraysize);
        } else if (datatype.equals("char")) {
            dec = CharDecoders.makeCharDecoder(arraysize);
        } else if (datatype.equals("unicodeChar")) {
            dec = CharDecoders.makeUnicodeCharDecoder(arraysize);
        } else if (datatype.equals("float")) {
            dec = isScalar ? new ScalarFloatDecoder() : new FloatDecoder(arraysize);
        } else if (datatype.equals("double")) {
            dec = isScalar ? new ScalarDoubleDecoder() : new DoubleDecoder(arraysize);
        } else if (datatype.equals("floatComplex")) {
            long[] arraysize2 = new long[arraysize.length + 1];
            arraysize2[0] = 2L;
            System.arraycopy(arraysize, 0, arraysize2, 1, arraysize.length);
            dec = new FloatDecoder(arraysize2);
        } else if (datatype.equals("doubleComplex")) {
            long[] arraysize2 = new long[arraysize.length + 1];
            arraysize2[0] = 2L;
            System.arraycopy(arraysize, 0, arraysize2, 1, arraysize.length);
            dec = new DoubleDecoder(arraysize2);
        } else {
            logger.warning("Unknown data type " + datatype + " - treat as string" + ", but may cause problems");
            dec = new UnknownDecoder();
        }
        if (blank != null && blank.trim().length() > 0) {
            try {
                ((Decoder)dec).setNullValue(blank);
            }
            catch (IllegalArgumentException e) {
                logger.warning("Bad null value " + blank);
            }
        }
        return dec;
    }

    static int[] longsToInts(long[] larray) {
        int[] iarray = new int[larray.length];
        for (int i = 0; i < larray.length; ++i) {
            if (larray[i] < Integer.MIN_VALUE || larray[i] > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Long value " + larray[i] + " out of integer range");
            }
            iarray[i] = (int)larray[i];
        }
        return iarray;
    }

    private static class UnknownDecoder
    extends Decoder {
        public UnknownDecoder() {
            super(String.class, new long[0]);
        }

        @Override
        public Object decodeString(String txt) {
            return txt;
        }

        @Override
        public Object decodeStream(DataInput strm) {
            throw new UnsupportedOperationException("Can't do STREAM decode of unknown data type " + this);
        }

        @Override
        public void skipStream(DataInput strm) {
            this.decodeStream(strm);
        }

        @Override
        void setNullValue(String txt) {
        }

        @Override
        public boolean isNull(Object array, int index) {
            return false;
        }
    }
}

