/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOStarTable;

abstract class Encoder {
    private final ValueInfo info_;
    private final Map<String, String> attMap_;
    private final String description_;
    private final String links_;
    private String nullString_;
    private String content_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    public abstract String encodeAsText(Object var1);

    public abstract void encodeToStream(Object var1, DataOutput var2) throws IOException;

    private Encoder(ValueInfo info, String datatype) {
        String desc;
        String utype;
        String ucd;
        String units;
        this.info_ = info;
        this.attMap_ = new LinkedHashMap<String, String>();
        this.putAtt("datatype", datatype.trim());
        String name = info.getName();
        if (name != null && name.trim().length() > 0) {
            this.putAtt("name", name.trim());
        }
        if ((units = info.getUnitString()) != null && units.trim().length() > 0) {
            this.putAtt("unit", units.trim());
        }
        if ((ucd = info.getUCD()) != null && ucd.trim().length() > 0) {
            this.putAtt("ucd", ucd.trim());
        }
        if ((utype = info.getUtype()) != null && utype.trim().length() > 0) {
            this.putAtt("utype", utype.trim());
        }
        if (info instanceof ColumnInfo) {
            String precision;
            Integer width;
            String xtype;
            String ref;
            ColumnInfo cinfo = (ColumnInfo)info;
            String id = (String)cinfo.getAuxDatumValue(VOStarTable.ID_INFO, String.class);
            if (id != null && id.trim().length() > 0) {
                this.putAtt("ID", id.trim());
            }
            if ((ref = (String)cinfo.getAuxDatumValue(VOStarTable.REF_INFO, String.class)) != null && ref.trim().length() > 0) {
                this.putAtt("ref", ref.trim());
            }
            if ((xtype = (String)cinfo.getAuxDatumValue(VOStarTable.XTYPE_INFO, String.class)) != null && xtype.trim().length() > 0) {
                this.putAtt("xtype", xtype.trim());
            }
            if ((width = (Integer)cinfo.getAuxDatumValue(VOStarTable.WIDTH_INFO, Integer.class)) != null && width > 0) {
                this.putAtt("width", width.toString());
            }
            if ((precision = (String)cinfo.getAuxDatumValue(VOStarTable.PRECISION_INFO, String.class)) != null && precision.trim().length() > 0) {
                this.putAtt("precision", precision.trim());
            }
        }
        desc = (desc = info.getDescription()) == null ? null : desc.trim();
        String string = this.description_ = desc == null || desc.length() == 0 ? null : "<DESCRIPTION>" + VOSerializer.formatText(desc) + "</DESCRIPTION>";
        if (info instanceof ColumnInfo) {
            StringBuffer linksBuf = new StringBuffer();
            for (DescribedValue dval : ((ColumnInfo)info).getAuxData()) {
                ValueInfo linkInfo = dval.getInfo();
                if (!URL.class.equals((Object)linkInfo.getContentClass())) continue;
                String linkName = linkInfo.getName();
                URL linkUrl = (URL)dval.getValue();
                if (linkName == null || linkUrl == null) continue;
                if (linksBuf.length() > 0) {
                    linksBuf.append('\n');
                }
                linksBuf.append("<LINK").append(VOSerializer.formatAttribute("title", linkName)).append(VOSerializer.formatAttribute("href", linkUrl.toString())).append("/>");
            }
            this.links_ = linksBuf.toString();
        } else {
            this.links_ = null;
        }
    }

    public String getFieldContent() {
        if (this.content_ == null) {
            StringBuffer contBuf = new StringBuffer();
            if (this.description_ != null && this.description_.trim().length() > 0) {
                contBuf.append('\n').append(this.description_);
            }
            if (this.nullString_ != null && this.nullString_.trim().length() > 0) {
                contBuf.append('\n').append("<VALUES null='" + this.nullString_ + "'/>");
            }
            if (this.links_ != null && this.links_.trim().length() > 0) {
                contBuf.append('\n').append(this.links_);
            }
            this.content_ = contBuf.toString();
        }
        return this.content_;
    }

    public Map getFieldAttributes() {
        return this.attMap_;
    }

    public void setNullString(String nullString) {
        this.nullString_ = nullString;
    }

    public ValueInfo getInfo() {
        return this.info_;
    }

    void putAtt(String key, String value) {
        this.attMap_.put(key, value);
    }

    public static Encoder getEncoder(ValueInfo info, boolean magicNulls, boolean useUnicodeChar) {
        Encoder1 enc1;
        String badString;
        Object o;
        DescribedValue nullValue;
        final CharWriter cwrite = useUnicodeChar ? CharWriter.UCS2 : CharWriter.ASCII;
        Class clazz = info.getContentClass();
        int[] dims = info.getShape();
        boolean isNullable = info.isNullable() && magicNulls;
        final boolean isVariable = dims != null && dims.length > 0 && dims[dims.length - 1] < 0;
        boolean isUbyte = false;
        if (info instanceof ColumnInfo && Boolean.TRUE.equals(((ColumnInfo)info).getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class))) {
            if (clazz == short[].class || clazz == Short.class) {
                isUbyte = true;
            } else {
                logger.warning("Ignoring " + Tables.UBYTE_FLAG_INFO + " on non-short column " + info);
            }
        }
        Number nullObj = null;
        if (info instanceof ColumnInfo && (nullValue = ((ColumnInfo)info).getAuxDatum(Tables.NULL_VALUE_INFO)) != null && (o = nullValue.getValue()) instanceof Number) {
            nullObj = (Number)o;
        }
        if (clazz == Boolean.class) {
            return new ScalarEncoder(info, "boolean", null){

                @Override
                public String encodeAsText(Object val) {
                    Boolean value = (Boolean)val;
                    return value == null ? "" : (value != false ? "T" : "F");
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Boolean value = (Boolean)val;
                    int b = value == null ? 32 : (value != false ? 84 : 70);
                    out.write(b);
                }
            };
        }
        if (isUbyte && clazz == Short.class) {
            final int badVal = nullObj == null ? (magicNulls ? 255 : 0) : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "unsignedByte", badString){

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeByte(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == Byte.class || clazz == Short.class) {
            final int badVal = nullObj == null ? (magicNulls ? Short.MIN_VALUE : 0) : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "short", badString){

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeShort(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == Integer.class) {
            final int badVal = nullObj == null ? (magicNulls ? Integer.MIN_VALUE : 0) : nullObj.intValue();
            badString = isNullable ? Integer.toString(badVal) : null;
            return new ScalarEncoder(info, "int", badString){

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeInt(value == null ? badVal : value.intValue());
                }
            };
        }
        if (clazz == Long.class) {
            final long badVal = nullObj == null ? (magicNulls ? Long.MIN_VALUE : 0L) : nullObj.longValue();
            String badString2 = isNullable ? Long.toString(badVal) : null;
            return new ScalarEncoder(info, "long", badString2){

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeLong(value == null ? badVal : value.longValue());
                }
            };
        }
        if (clazz == Float.class) {
            return new ScalarEncoder(info, "float", null){

                @Override
                public String encodeAsText(Object val) {
                    if (val instanceof Float && Float.isInfinite(((Float)val).floatValue())) {
                        return Encoder.infinityText(((Float)val).floatValue() > 0.0f);
                    }
                    return super.encodeAsText(val);
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeFloat(value == null ? Float.NaN : value.floatValue());
                }
            };
        }
        if (clazz == Double.class) {
            return new ScalarEncoder(info, "double", null){

                @Override
                public String encodeAsText(Object val) {
                    if (val instanceof Double && Double.isInfinite((Double)val)) {
                        return Encoder.infinityText((Double)val > 0.0);
                    }
                    return super.encodeAsText(val);
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Number value = (Number)val;
                    out.writeDouble(value == null ? Double.NaN : value.doubleValue());
                }
            };
        }
        if (clazz == Character.class) {
            boolean badVal = false;
            return new ScalarEncoder(info, cwrite.getDatatype(), null){
                {
                    super(x0, x1, x2);
                    this.putAtt("arraysize", "1");
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    Character value = (Character)val;
                    cwrite.writeChar(out, value == null ? (char)'\u0000' : value.charValue());
                }
            };
        }
        if (clazz == boolean[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    boolean value = ((boolean[])array)[index];
                    out.write(value ? 84 : 70);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.write(32);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "boolean", dims, enc1) : new FixedArrayEncoder(info, "boolean", dims, enc1);
        }
        if (isUbyte && clazz == short[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    short value = ((short[])array)[index];
                    out.writeByte(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeByte(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "unsignedByte", dims, enc1) : new FixedArrayEncoder(info, "unsignedByte", dims, enc1);
        }
        if (clazz == byte[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    byte value = ((byte[])array)[index];
                    out.writeShort(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == short[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    short value = ((short[])array)[index];
                    out.writeShort(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeShort(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "short", dims, enc1) : new FixedArrayEncoder(info, "short", dims, enc1);
        }
        if (clazz == int[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    int value = ((int[])array)[index];
                    out.writeInt(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeInt(0);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "int", dims, enc1) : new FixedArrayEncoder(info, "int", dims, enc1);
        }
        if (clazz == long[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    long value = ((long[])array)[index];
                    out.writeLong(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeLong(0L);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "long", dims, enc1) : new FixedArrayEncoder(info, "long", dims, enc1);
        }
        if (clazz == float[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    float value = ((float[])array)[index];
                    out.writeFloat(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeFloat(Float.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "float", dims, enc1) : new FixedArrayEncoder(info, "float", dims, enc1);
        }
        if (clazz == double[].class) {
            enc1 = new Encoder1(){

                @Override
                public void encode1(Object array, int index, DataOutput out) throws IOException {
                    double value = ((double[])array)[index];
                    out.writeDouble(value);
                }

                @Override
                public void pad1(DataOutput out) throws IOException {
                    out.writeDouble(Double.NaN);
                }
            };
            return isVariable ? new VariableArrayEncoder(info, "double", dims, enc1) : new FixedArrayEncoder(info, "double", dims, enc1);
        }
        if (clazz == String.class) {
            int nChar;
            int n = nChar = clazz == String.class ? info.getElementSize() : -1;
            if (nChar > 0) {
                return new Encoder(info, cwrite.getDatatype()){
                    {
                        super(x0, x1);
                        this.putAtt("arraysize", Integer.toString(nChar));
                    }

                    @Override
                    public String encodeAsText(Object val) {
                        return val == null ? "" : val.toString();
                    }

                    @Override
                    public void encodeToStream(Object val, DataOutput out) throws IOException {
                        int i;
                        if (val != null) {
                            String value = val.toString();
                            int limit = Math.min(value.length(), nChar);
                            for (i = 0; i < limit; ++i) {
                                cwrite.writeChar(out, value.charAt(i));
                            }
                        }
                        while (i < nChar) {
                            cwrite.writeChar(out, '\u0000');
                            ++i;
                        }
                    }
                };
            }
            return new Encoder(info, cwrite.getDatatype()){
                {
                    super(x0, x1);
                    this.putAtt("arraysize", "*");
                }

                @Override
                public String encodeAsText(Object val) {
                    return val == null ? "" : val.toString();
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    if (val == null) {
                        out.writeInt(0);
                    } else {
                        String value = val.toString();
                        int leng = value.length();
                        out.writeInt(leng);
                        for (int i = 0; i < leng; ++i) {
                            cwrite.writeChar(out, value.charAt(i));
                        }
                    }
                }
            };
        }
        if (clazz == String[].class) {
            int nChar;
            int n = nChar = clazz == String[].class ? info.getElementSize() : -1;
            if (nChar < 0) {
                logger.warning("Oh dear - can't serialize array of variable-length strings to VOTable - sorry");
                return null;
            }
            int[] charDims = new int[dims.length + 1];
            charDims[0] = nChar;
            System.arraycopy(dims, 0, charDims, 1, dims.length);
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < charDims.length; ++i) {
                if (i > 0) {
                    sbuf.append('x');
                }
                if (i == charDims.length - 1 && charDims[i] < 0) {
                    sbuf.append('*');
                    continue;
                }
                sbuf.append(charDims[i]);
            }
            int ns = 0;
            if (!isVariable) {
                ns = 1;
                for (int i = 0; i < dims.length; ++i) {
                    ns *= dims[i];
                }
            }
            final String arraysize = sbuf.toString();
            final int nString = ns;
            return new Encoder(info, cwrite.getDatatype()){
                char[] cbuf;
                {
                    super(x0, x1);
                    this.cbuf = new char[nChar];
                    this.putAtt("arraysize", arraysize);
                }

                @Override
                public String encodeAsText(Object val) {
                    if (val != null) {
                        Object[] value = (Object[])val;
                        StringBuffer sbuf = new StringBuffer();
                        for (int i = 0; i < value.length; ++i) {
                            int j;
                            Object el = value[i];
                            String str = el == null ? "" : el.toString();
                            int limit = Math.min(str.length(), nChar);
                            for (j = 0; j < limit; ++j) {
                                this.cbuf[j] = str.charAt(j);
                            }
                            while (j < nChar) {
                                this.cbuf[j] = 32;
                                ++j;
                            }
                            sbuf.append(new String(this.cbuf));
                        }
                        return sbuf.toString();
                    }
                    return null;
                }

                @Override
                public void encodeToStream(Object val, DataOutput out) throws IOException {
                    int is;
                    int slimit;
                    Object[] value;
                    Object[] objectArray = value = val == null ? new Object[]{} : (Object[])val;
                    if (isVariable) {
                        slimit = value.length;
                        out.writeInt(nChar * slimit);
                    } else {
                        slimit = Math.min(value.length, nString);
                    }
                    for (is = 0; is < slimit; ++is) {
                        int ic;
                        Object v = value[is];
                        String str = v == null ? "" : v.toString();
                        int climit = Math.min(str.length(), nChar);
                        for (ic = 0; ic < climit; ++ic) {
                            cwrite.writeChar(out, str.charAt(ic));
                        }
                        while (ic < nChar) {
                            cwrite.writeChar(out, '\u0000');
                            ++ic;
                        }
                    }
                    if (!isVariable) {
                        int nc = (nString - is) * nChar;
                        for (int ic = 0; ic < nc; ++ic) {
                            cwrite.writeChar(out, '\u0000');
                        }
                    }
                }
            };
        }
        return null;
    }

    private static String infinityText(boolean isPositive) {
        return isPositive ? "+Inf" : "-Inf";
    }

    private static abstract class CharWriter {
        private final String datatype_;
        public static final CharWriter ASCII = new CharWriter("char"){

            @Override
            public void writeChar(DataOutput out, char c) throws IOException {
                out.write(c);
            }
        };
        public static final CharWriter UCS2 = new CharWriter("unicodeChar"){

            @Override
            public void writeChar(DataOutput out, char c) throws IOException {
                out.writeChar(c);
            }
        };

        public CharWriter(String datatype) {
            this.datatype_ = datatype;
        }

        public String getDatatype() {
            return this.datatype_;
        }

        public abstract void writeChar(DataOutput var1, char var2) throws IOException;
    }

    private static interface Encoder1 {
        public void encode1(Object var1, int var2, DataOutput var3) throws IOException;

        public void pad1(DataOutput var1) throws IOException;
    }

    private static class FixedArrayEncoder
    extends ArrayEncoder {
        final int nfixed;

        FixedArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
            int nfixed = 1;
            for (int i = 0; i < dims.length; ++i) {
                nfixed *= dims[i];
            }
            this.nfixed = nfixed;
        }

        @Override
        public void encodeToStream(Object val, DataOutput out) throws IOException {
            int i;
            if (val != null) {
                int nel = Array.getLength(val);
                int limit = Math.min(nel, this.nfixed);
                for (i = 0; i < limit; ++i) {
                    this.enc1.encode1(val, i, out);
                }
            }
            while (i < this.nfixed) {
                this.enc1.pad1(out);
                ++i;
            }
        }
    }

    private static class VariableArrayEncoder
    extends ArrayEncoder {
        VariableArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype, dims, enc1);
        }

        @Override
        public void encodeToStream(Object val, DataOutput out) throws IOException {
            if (val == null) {
                out.writeInt(0);
            } else {
                int nel = Array.getLength(val);
                out.writeInt(nel);
                for (int i = 0; i < nel; ++i) {
                    this.enc1.encode1(val, i, out);
                }
            }
        }
    }

    private static abstract class ArrayEncoder
    extends Encoder {
        final Encoder1 enc1;

        ArrayEncoder(ValueInfo info, String datatype, int[] dims, Encoder1 enc1) {
            super(info, datatype);
            this.enc1 = enc1;
            StringBuffer sizeBuf = new StringBuffer();
            for (int i = 0; i < dims.length; ++i) {
                if (i > 0) {
                    sizeBuf.append('x');
                }
                if (i == dims.length - 1 && dims[i] < 0) {
                    sizeBuf.append('*');
                    continue;
                }
                sizeBuf.append(dims[i]);
            }
            this.putAtt("arraysize", sizeBuf.toString());
        }

        @Override
        public String encodeAsText(Object val) {
            if (val == null) {
                return "";
            }
            int nel = Array.getLength(val);
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < nel; ++i) {
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(Array.get(val, i).toString());
            }
            return sbuf.toString();
        }
    }

    private static abstract class ScalarEncoder
    extends Encoder {
        private final String nullText;

        ScalarEncoder(ValueInfo info, String datatype, String nullString) {
            super(info, datatype);
            this.setNullString(nullString);
            this.nullText = nullString == null ? "" : nullString;
        }

        @Override
        public String encodeAsText(Object val) {
            return val == null ? this.nullText : val.toString();
        }
    }
}

