/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedDataInputStream;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.QueueTableSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class FitsPlusTableBuilder
implements TableBuilder,
MultiTableBuilder {
    private final WideFits wide_;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    public FitsPlusTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public FitsPlusTableBuilder(WideFits wide) {
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "FITS-plus";
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (!FitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS-plus file");
        }
        ArrayDataInput strm = FitsConstants.getInputStreamStart((DataSource)datsrc);
        try {
            long[] pos = new long[1];
            TableElement[] tabels = FitsPlusTableBuilder.readMetadata(strm, pos);
            int iTable = FitsPlusTableBuilder.getTableIndex(datsrc.getPosition(), tabels.length);
            TableElement tabel = tabels[iTable];
            pos[0] = pos[0] + FitsConstants.skipHDUs((ArrayDataInput)strm, (int)iTable);
            StarTable starTable = FitsTableBuilder.attemptReadTable((ArrayDataInput)strm, (boolean)wantRandom, (DataSource)datsrc, (WideFits)this.wide_, (long[])pos);
            if (starTable == null) {
                throw new TableFormatException("No BINTABLE HDU found");
            }
            return FitsPlusTableBuilder.createFitsPlusTable(tabel, starTable);
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        catch (NullPointerException e) {
            throw new TableFormatException("Table not quite in fits-plus format", e);
        }
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy storagePolicy) throws IOException {
        String srcpos = datsrc.getPosition();
        if (srcpos != null && srcpos.trim().length() > 0) {
            return Tables.singleTableSequence(this.makeStarTable(datsrc, false, storagePolicy));
        }
        if (!FitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS-plus file");
        }
        MultiLoadWorker loadWorker = new MultiLoadWorker(datsrc, this.wide_);
        loadWorker.start();
        return loadWorker.getTableSequence();
    }

    @Override
    public void streamStarTable(InputStream in, final TableSink sink, String pos) throws IOException {
        BufferedDataInputStream strm = new BufferedDataInputStream(in);
        try {
            TableElement[] tabels = FitsPlusTableBuilder.readMetadata(strm, new long[1]);
            int iTable = FitsPlusTableBuilder.getTableIndex(pos, tabels.length);
            TableElement tabel = tabels[iTable];
            FitsConstants.skipHDUs((ArrayDataInput)strm, (int)iTable);
            final VOStarTable voMeta = new VOStarTable(tabel);
            TableSink wsink = new TableSink(){

                @Override
                public void acceptMetadata(StarTable fitsMeta) throws TableFormatException {
                    sink.acceptMetadata(voMeta);
                }

                @Override
                public void acceptRow(Object[] row) throws IOException {
                    sink.acceptRow(row);
                }

                @Override
                public void endRows() throws IOException {
                    sink.endRows();
                }
            };
            Header hdr = new Header();
            FitsConstants.readHeader((Header)hdr, (ArrayDataInput)strm);
            BasicInput input = InputFactory.createSequentialInput((DataInput)strm);
            BintableStarTable.streamStarTable((Header)hdr, (BasicInput)input, (WideFits)this.wide_, (TableSink)wsink);
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        finally {
            strm.close();
        }
    }

    private static TableElement[] readMetadata(ArrayDataInput strm, long[] pos) throws IOException {
        byte[] headBuf = new byte[2880];
        strm.readFully(headBuf);
        if (!FitsPlusTableBuilder.isMagic(headBuf)) {
            throw new TableFormatException("Primary header not FITS-plus");
        }
        try {
            Header hdr = new Header();
            BufferedDataInputStream hstrm = new BufferedDataInputStream(new ByteArrayInputStream(headBuf));
            int headsize = FitsConstants.readHeader((Header)hdr, (ArrayDataInput)hstrm);
            int datasize = (int)FitsConstants.getDataSize((Header)hdr);
            pos[0] = headsize + datasize;
            assert (headsize == 2880);
            assert (hdr.getIntValue("NAXIS") == 1);
            assert (hdr.getIntValue("BITPIX") == 8);
            int nbyte = hdr.getIntValue("NAXIS1");
            byte[] vobuf = new byte[nbyte];
            strm.readFully(vobuf);
            int pad = datasize - nbyte;
            IOUtils.skipBytes(strm, pad);
            VOElementFactory vofact = new VOElementFactory();
            DOMSource domsrc = vofact.transformToDOM(new StreamSource(new ByteArrayInputStream(vobuf)), false);
            VODocument doc = (VODocument)domsrc.getNode();
            VOElement topel = (VOElement)doc.getDocumentElement();
            NodeList tlist = topel.getElementsByVOTagName("TABLE");
            int nTable = tlist.getLength();
            TableElement[] tabels = new TableElement[nTable];
            for (int i = 0; i < nTable; ++i) {
                tabels[i] = (TableElement)tlist.item(i);
                if (tabels[i].getChildByName("DATA") == null) continue;
                throw new TableFormatException("TABLE #" + (i + i) + " in embedded VOTable document " + "has unexpected DATA element");
            }
            return tabels;
        }
        catch (FitsException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new TableFormatException(e.getMessage(), e);
        }
    }

    private static int getTableIndex(String pos, int nTable) throws TableFormatException {
        if (nTable <= 0) {
            throw new TableFormatException("No tables present in FITS-plus container");
        }
        if (pos == null || pos.trim().length() == 0) {
            return 0;
        }
        try {
            int index = Integer.parseInt(pos.trim());
            if (index >= 1 && index <= nTable) {
                return index - 1;
            }
            if (index == 0) {
                throw new TableFormatException("No table with position " + pos + "; first table is " + "#1");
            }
            throw new TableFormatException("No table with position " + pos + "; there are " + nTable);
        }
        catch (NumberFormatException e) {
            throw new TableFormatException("Can't interpret position " + pos + " (not a number)", e);
        }
    }

    private static StarTable createFitsPlusTable(TableElement tabEl, StarTable dataTable) throws IOException {
        FieldElement[] fields = tabEl.getFields();
        if (fields.length != dataTable.getColumnCount()) {
            throw new TableFormatException("FITS/VOTable metadata mismatch - column counts differ");
        }
        for (int ic = 0; ic < fields.length; ++ic) {
            Class vclazz;
            Class fclazz = dataTable.getColumnInfo(ic).getContentClass();
            if (fclazz.equals(vclazz = fields[ic].getDecoder().getContentClass()) || (fclazz.equals(String.class) || fclazz.equals(Character.class) || fclazz.equals(char[].class)) && (vclazz.equals(String.class) || vclazz.equals(Character.class) || vclazz.equals(char[].class))) continue;
            throw new TableFormatException("FITS/VOTable metadata mismatch - column types differ");
        }
        tabEl.setData(new TableBodies.StarTableTabularData(dataTable));
        VOStarTable outTable = new VOStarTable(tabEl);
        int ncol = dataTable.getColumnCount();
        assert (ncol == outTable.getColumnCount());
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo fInfo = dataTable.getColumnInfo(icol);
            ColumnInfo vInfo = outTable.getColumnInfo(icol);
            if (vInfo.getContentClass().isAssignableFrom(fInfo.getContentClass())) continue;
            vInfo.setContentClass(fInfo.getContentClass());
        }
        return outTable;
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    public static boolean isMagic(byte[] buffer) {
        int ntest = 5;
        int pos = 0;
        boolean ncard = false;
        boolean ok = true;
        for (int il = 0; ok && il < 5; ++il) {
            if (buffer.length <= pos + 80) continue;
            char[] cbuf = new char[80];
            for (int ic = 0; ic < 80; ++ic) {
                cbuf[ic] = (char)(buffer[pos++] & 0xFF);
            }
            try {
                HeaderCard card = new HeaderCard(new String(cbuf));
                ok = ok && FitsPlusTableBuilder.cardOK(il, card);
                continue;
            }
            catch (FitsException e) {
                ok = false;
            }
        }
        return ok;
    }

    private static boolean cardOK(int icard, HeaderCard card) throws FitsException {
        String key = card.getKey();
        String value = card.getValue();
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && "T".equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && "8".equals(value);
            }
            case 2: {
                return "NAXIS".equals(key) && "1".equals(value);
            }
            case 3: {
                return "NAXIS1".equals(key);
            }
            case 4: {
                return "VOTMETA".equals(key) && "T".equals(value);
            }
        }
        return true;
    }

    private static class MultiLoadWorker
    extends Thread {
        private final DataSource datsrc_;
        private final WideFits wide_;
        private final QueueTableSequence tqueue_;

        MultiLoadWorker(DataSource datsrc, WideFits wide) {
            super("FITS-plus multi table loader");
            this.setDaemon(true);
            this.datsrc_ = datsrc;
            this.wide_ = wide;
            this.tqueue_ = new QueueTableSequence();
        }

        TableSequence getTableSequence() {
            return this.tqueue_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.multiLoad();
            }
            catch (Throwable e) {
                this.tqueue_.addError(e);
            }
            finally {
                this.tqueue_.endSequence();
            }
        }

        private void multiLoad() throws IOException, FitsException {
            ArrayDataInput in = FitsConstants.getInputStreamStart((DataSource)this.datsrc_);
            long[] posptr = new long[1];
            TableElement[] tabEls = FitsPlusTableBuilder.readMetadata(in, posptr);
            long pos = posptr[0];
            int nTable = tabEls.length;
            for (int itab = 0; itab < nTable; ++itab) {
                Header hdr = new Header();
                int headsize = FitsConstants.readHeader((Header)hdr, (ArrayDataInput)in);
                long datasize = FitsConstants.getDataSize((Header)hdr);
                long datpos = pos + (long)headsize;
                if (!"BINTABLE".equals(hdr.getStringValue("XTENSION"))) {
                    throw new TableFormatException("Non-BINTABLE at ext #" + itab + " - not FITS-plus");
                }
                InputFactory inFact = InputFactory.createFactory((DataSource)this.datsrc_, (long)datpos, (long)datasize);
                BintableStarTable dataTable = BintableStarTable.createTable((Header)hdr, (InputFactory)inFact, (WideFits)this.wide_);
                this.tqueue_.addTable(FitsPlusTableBuilder.createFitsPlusTable(tabEls[itab], (StarTable)dataTable));
                IOUtils.skipBytes(in, datasize);
                pos += (long)headsize + datasize;
            }
            in.close();
        }
    }
}

